/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.inventory.menus;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.entity.Spaceship;
import com.shim.celestialexploration.inventory.OxygenTankSlot;
import com.shim.celestialexploration.registry.MenuRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SpaceshipMenu
extends AbstractContainerMenu {
    private final Spaceship entity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 31;

    public SpaceshipMenu(int containerId, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(containerId, inventory, inventory.f_35978_.f_19853_.m_6815_(friendlyByteBuf.readInt()));
    }

    public SpaceshipMenu(int containerId, Inventory inv, Entity spaceship) {
        super((MenuType)MenuRegistry.SPACESHIP_MENU.get(), containerId);
        SpaceshipMenu.m_38869_((Container)inv, (int)31);
        this.entity = (Spaceship)spaceship;
        this.level = inv.f_35978_.f_19853_;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            this.m_38897_((Slot)new OxygenTankSlot((IItemHandler)handler, 0, 26, 18));
            this.m_38897_((Slot)new OxygenTankSlot((IItemHandler)handler, 1, 62, 18));
            this.m_38897_((Slot)new OxygenTankSlot((IItemHandler)handler, 2, 98, 18));
            this.m_38897_((Slot)new OxygenTankSlot((IItemHandler)handler, 3, 134, 18));
            for (int i = 0; i < 3; ++i) {
                for (int l = 0; l < 9; ++l) {
                    this.m_38897_((Slot)new SlotItemHandler(handler, l + i * 9 + 4, 8 + l * 18, 50 + i * 18));
                }
            }
        });
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 67, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 67) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            CelestialExploration.LOGGER.debug("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player player) {
        return this.entity.m_20270_((Entity)player) < 8.0f;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 118 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 176));
        }
    }

    public void setCooldown() {
        this.entity.setInventoryCooldown(10);
    }
}

