/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.item.armor;

import com.google.common.collect.ImmutableMap;
import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.item.ModArmorMaterials;
import com.shim.celestialexploration.item.armor.HeavyDutySpaceSuitRenderer;
import java.util.Map;
import java.util.function.Consumer;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.Nullable;

public class HeavyDutySpaceSuitArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Map<ArmorMaterial, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ModArmorMaterials.HEAVY_DUTY_SPACESUIT, (Object)new MobEffectInstance(MobEffects.f_19603_, 300, 1, false, false, false)).build();

    public HeavyDutySpaceSuitArmorItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerName", 0, event -> event.setAndContinue(RawAnimation.begin().thenLoop("spacesuit.idle")))});
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            private HeavyDutySpaceSuitRenderer renderer;

            @Nullable
            public HumanoidModel<?> getArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new HeavyDutySpaceSuitRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, armorSlot, original);
                return this.renderer;
            }
        });
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.m_5776_() && this.hasFullSuitOfArmorOn(player)) {
            this.evaluateArmorEffects(player);
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.m_41720_() instanceof ArmorItem && ((ArmorItem)stack.m_41720_()).m_40402_() == EquipmentSlot.CHEST;
    }

    public boolean isDamaged(ItemStack stack) {
        return super.isDamaged(stack);
    }

    private void evaluateArmorEffects(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffectInstance mapStatusEffect = entry.getValue();
            CelestialExploration.LOGGER.debug("effect is visible: " + mapStatusEffect.m_19572_());
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
        }
    }

    private void addStatusEffectForMaterial(Player player, ArmorMaterial mapArmorMaterial, MobEffectInstance mapStatusEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapStatusEffect.m_19544_());
        if (this.hasCorrectArmorOn(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect.m_19544_(), mapStatusEffect.m_19557_(), mapStatusEffect.m_19564_(), mapStatusEffect.m_19571_(), mapStatusEffect.m_19572_()));
        }
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack breastplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !breastplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    private boolean hasCorrectArmorOn(ArmorMaterial material, Player player) {
        for (ItemStack armorStack : player.m_150109_().f_35975_) {
            if (armorStack.m_41720_() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem breastplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return helmet.m_40401_() == material && breastplate.m_40401_() == material && leggings.m_40401_() == material && boots.m_40401_() == material;
    }
}

