/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.packets;

import com.shim.celestialexploration.entity.Spaceship;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class SpaceshipInventoryPacket {
    int spaceshipId;

    public SpaceshipInventoryPacket(int spaceshipId) {
        this.spaceshipId = spaceshipId;
    }

    public static void encoder(SpaceshipInventoryPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.spaceshipId);
    }

    public static SpaceshipInventoryPacket decoder(FriendlyByteBuf buffer) {
        return new SpaceshipInventoryPacket(buffer.readInt());
    }

    public static void handle(SpaceshipInventoryPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = player.f_19853_.m_6815_(message.spaceshipId)) instanceof Spaceship) {
                Spaceship spaceship = (Spaceship)entity;
                NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)spaceship, buf -> buf.writeInt(message.spaceshipId));
            }
        });
        context.setPacketHandled(true);
    }
}

