/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class OxygenCompressorRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;

    public OxygenCompressorRecipe(ResourceLocation id, Ingredient ingredient, float experience, int cookingTime) {
        this.id = id;
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public boolean matches(SimpleContainer container, Level level) {
        return this.ingredient.test(container.m_8020_(0)) || this.ingredient.test(container.m_8020_(1)) || this.ingredient.test(container.m_8020_(2)) || this.ingredient.test(container.m_8020_(3));
    }

    public ItemStack assemble(SimpleContainer container) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_.m_41777_();
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<OxygenCompressorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("celestialexploration", "oxygen_compressor");

        public OxygenCompressorRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int cookingTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)100);
            return new OxygenCompressorRecipe(id, ingredient, experience, cookingTime);
        }

        public OxygenCompressorRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            float experience = buf.readFloat();
            int cookingTime = buf.m_130242_();
            return new OxygenCompressorRecipe(id, ingredient, experience, cookingTime);
        }

        public void toNetwork(FriendlyByteBuf buf, OxygenCompressorRecipe recipe) {
            recipe.ingredient.m_43923_(buf);
            buf.writeFloat(recipe.experience);
            buf.m_130130_(recipe.cookingTime);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }

    public static class Type
    implements RecipeType<OxygenCompressorRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "celestialexploration:oxygen_compressor";

        private Type() {
        }
    }
}

