/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.recipes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.shim.celestialexploration.inventory.containers.WorkbenchCraftingContainer;
import com.shim.celestialexploration.util.CelestialJsonHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class WorkbenchCraftingRecipe
implements Recipe<WorkbenchCraftingContainer> {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    private final ResourceLocation id;
    private final ItemStack result;
    private final NonNullList<Ingredient> recipeItems;
    final String group;
    final int width;
    final int height;
    private final FluidStack fluidIngredient;
    private final float buckets;
    private final float experience;

    public WorkbenchCraftingRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> recipeItems, FluidStack fluidIngredient, float buckets, ItemStack result, float experience) {
        this.id = id;
        this.group = group;
        this.width = width;
        this.height = height;
        this.recipeItems = recipeItems;
        this.fluidIngredient = fluidIngredient;
        this.buckets = buckets;
        this.result = result;
        this.experience = experience;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean matches(WorkbenchCraftingContainer container, Level level) {
        if (!container.getTank().getFluid().containsFluid(this.fluidIngredient)) {
            return false;
        }
        for (int i = 0; i <= container.getWidth() - this.width; ++i) {
            for (int j = 0; j <= container.getHeight() - this.height; ++j) {
                if (this.matches(container, i, j, true)) {
                    return true;
                }
                if (!this.matches(container, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(WorkbenchCraftingContainer p_44171_, int p_44172_, int p_44173_, boolean p_44174_) {
        for (int i = 0; i < p_44171_.getWidth(); ++i) {
            for (int j = 0; j < p_44171_.getHeight(); ++j) {
                int k = i - p_44172_;
                int l = j - p_44173_;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = p_44174_ ? (Ingredient)this.recipeItems.get(this.width - k - 1 + l * this.width) : (Ingredient)this.recipeItems.get(k + l * this.width);
                }
                if (ingredient.test(p_44171_.m_8020_(i + j * p_44171_.getWidth()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(WorkbenchCraftingContainer p_44169_) {
        return this.m_8043_().m_41777_();
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public float getBuckets() {
        return this.buckets;
    }

    public FluidStack getFluid() {
        return this.fluidIngredient;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    static NonNullList<Ingredient> dissolvePattern(String[] p_44203_, Map<String, Ingredient> p_44204_, int p_44205_, int p_44206_) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(p_44205_ * p_44206_), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(p_44204_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_44203_.length; ++i) {
            for (int j = 0; j < p_44203_[i].length(); ++j) {
                String s = p_44203_[i].substring(j, j + 1);
                Ingredient ingredient = p_44204_.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + p_44205_ * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... p_44187_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_44187_.length; ++i1) {
            String s = p_44187_[i1];
            i = Math.min(i, WorkbenchCraftingRecipe.firstNonSpace(s));
            int j1 = WorkbenchCraftingRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_44187_.length == l) {
            return new String[0];
        }
        String[] astring = new String[p_44187_.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_44187_[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> nonnulllist = this.m_7527_();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(p_151277_ -> !p_151277_.m_43947_()).anyMatch(p_151273_ -> ForgeHooks.hasNoElements((Ingredient)p_151273_));
    }

    private static int firstNonSpace(String p_44185_) {
        int i;
        for (i = 0; i < p_44185_.length() && p_44185_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String p_44201_) {
        int i;
        for (i = p_44201_.length() - 1; i >= 0 && p_44201_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] patternFromJson(JsonArray p_44197_) {
        String[] astring = new String[p_44197_.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)p_44197_.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    static Map<String, Ingredient> keyFromJson(JsonObject p_44211_) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : p_44211_.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack itemStackFromJson(JsonObject p_151275_) {
        return CraftingHelper.getItemStack((JsonObject)p_151275_, (boolean)true, (boolean)true);
    }

    public static Item itemFromJson(JsonObject p_151279_) {
        String s = GsonHelper.m_13906_((JsonObject)p_151279_, (String)"item");
        Item item = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + s);
        }
        return item;
    }

    public static class Serializer
    implements RecipeSerializer<WorkbenchCraftingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("celestialexploration", "workbench_crafting");

        public WorkbenchCraftingRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> map = WorkbenchCraftingRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = WorkbenchCraftingRecipe.shrink(WorkbenchCraftingRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList<Ingredient> ingredients = WorkbenchCraftingRecipe.dissolvePattern(pattern, map, width, height);
            FluidStack fluidIngredient = CelestialJsonHelper.getFluidStackFromJson(json, true, true, "fluid");
            float buckets = GsonHelper.m_13820_((JsonObject)json, (String)"buckets", (float)0.0f);
            float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            ItemStack result = WorkbenchCraftingRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new WorkbenchCraftingRecipe(id, group, width, height, ingredients, fluidIngredient, buckets, result, experience);
        }

        public WorkbenchCraftingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int width = buf.m_130242_();
            int height = buf.m_130242_();
            String group = buf.m_130277_();
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            FluidStack fluidIngredient = buf.readFluidStack();
            float buckets = buf.readFloat();
            ItemStack result = buf.m_130267_();
            float experience = buf.readFloat();
            return new WorkbenchCraftingRecipe(id, group, width, height, (NonNullList<Ingredient>)ingredients, fluidIngredient, buckets, result, experience);
        }

        public void toNetwork(FriendlyByteBuf buf, WorkbenchCraftingRecipe recipe) {
            buf.m_130130_(recipe.width);
            buf.m_130130_(recipe.height);
            buf.m_130070_(recipe.group);
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buf);
            }
            buf.writeFluidStack(recipe.fluidIngredient);
            buf.writeFloat(recipe.buckets);
            buf.m_130055_(recipe.result);
            buf.writeFloat(recipe.experience);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }

    public static class Type
    implements RecipeType<WorkbenchCraftingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "celestialexploration:workbench_crafting";

        private Type() {
        }
    }
}

