/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shim.celestialexploration.util.CelestialJsonHelper;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class WorkbenchSmeltingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final FluidStack fluidResult;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;
    private final float buckets;

    public WorkbenchSmeltingRecipe(ResourceLocation id, FluidStack fluidResult, Ingredient ingredient, float experience, int cookingTime, float buckets) {
        this.id = id;
        this.fluidResult = fluidResult;
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.buckets = buckets;
    }

    public boolean matches(SimpleContainer container, Level level) {
        return this.ingredient.test(container.m_8020_(0));
    }

    public ItemStack assemble(SimpleContainer container) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_.m_41777_();
    }

    public FluidStack getResultFluid() {
        return this.fluidResult.copy();
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public float getBuckets() {
        return this.buckets;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<WorkbenchSmeltingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("celestialexploration", "workbench_smelting");

        public WorkbenchSmeltingRecipe fromJson(ResourceLocation id, JsonObject json) {
            FluidStack fluidResult = CelestialJsonHelper.getFluidStackFromJson(json, true, true, "result");
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int cookingTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)100);
            float buckets = GsonHelper.m_13820_((JsonObject)json, (String)"buckets", (float)0.0f);
            return new WorkbenchSmeltingRecipe(id, fluidResult, ingredient, experience, cookingTime, buckets);
        }

        public WorkbenchSmeltingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            FluidStack fluidResult = buf.readFluidStack();
            float experience = buf.readFloat();
            int cookingTime = buf.m_130242_();
            float buckets = buf.readFloat();
            return new WorkbenchSmeltingRecipe(id, fluidResult, ingredient, experience, cookingTime, buckets);
        }

        public void toNetwork(FriendlyByteBuf buf, WorkbenchSmeltingRecipe recipe) {
            recipe.ingredient.m_43923_(buf);
            buf.writeFluidStack(recipe.getResultFluid());
            buf.writeFloat(recipe.experience);
            buf.m_130130_(recipe.cookingTime);
            buf.writeFloat(recipe.buckets);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }

    public static class Type
    implements RecipeType<WorkbenchSmeltingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "celestialexploration:workbench_smelting";

        private Type() {
        }
    }
}

