/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.util;

import com.shim.celestialexploration.config.CelestialCommonConfig;
import com.shim.celestialexploration.registry.DimensionRegistry;
import com.shim.celestialexploration.registry.FluidRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public class CelestialUtil {
    @Deprecated
    public static final Map<String, Vec3> PLANET_LOCATION = (Map)Util.m_137469_((Object)new Object2ObjectArrayMap(), dimension -> {
        dimension.put((Object)"Mercury", (Object)new Vec3(1.0, 0.0, 1.0));
        dimension.put((Object)"Venus", (Object)new Vec3(0.0, 0.0, 2.0));
        dimension.put((Object)"Overworld", (Object)new Vec3(-2.0, 0.0, 0.0));
        dimension.put((Object)"Mars", (Object)new Vec3(1.0, 0.0, -3.0));
        dimension.put((Object)"Jupiter", (Object)new Vec3(1.0, 0.0, -3.0));
        dimension.put((Object)"Saturn", (Object)new Vec3(1.0, 0.0, -3.0));
        dimension.put((Object)"Uranus", (Object)new Vec3(1.0, 0.0, -3.0));
        dimension.put((Object)"Neptune", (Object)new Vec3(1.0, 0.0, -3.0));
    });
    public static final Map<ResourceKey<Level>, Vec3> DIMENSION_LOCATION = (Map)Util.m_137469_((Object)new Object2ObjectArrayMap(), dimension -> {
        dimension.put(DimensionRegistry.MERCURY, (Object)new Vec3(1.0, 0.0, 1.0));
        dimension.put(DimensionRegistry.VENUS, (Object)new Vec3(0.0, 0.0, 2.0));
        dimension.put((Object)Level.f_46428_, (Object)new Vec3(-2.0, 0.0, 0.0));
        dimension.put(DimensionRegistry.MOON, (Object)new Vec3(-2.0, 0.0, 0.0));
        dimension.put(DimensionRegistry.MARS, (Object)new Vec3(1.0, 0.0, -3.0));
    });
    private static final ArrayList<CelestialBodyDetails> PLANET_DETAILS = (ArrayList)Util.m_137469_(new ArrayList(), list -> {
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.sun_name"), new Vec2(0.0f, 0.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.sun_resources")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.mercury_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)1).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)1).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.mercury_resources")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.venus_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)2).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)2).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.venus_resources")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.overworld_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)3).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)3).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.overworld_resources"), (Component)new TranslatableComponent("celestialexploration.planet_details.overworld_moons")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.mars_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)4).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)4).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.mars_resources")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.jupiter_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)5).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)5).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.jupiter_resources"), (Component)new TranslatableComponent("celestialexploration.planet_details.jupiter_moons")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.saturn_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)6).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)6).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.saturn_resources"), (Component)new TranslatableComponent("celestialexploration.planet_details.saturn_moons")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.uranus_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)7).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)7).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.uranus_resources"), (Component)new TranslatableComponent("celestialexploration.planet_details.uranus_moons")));
        list.add(new CelestialBodyDetails((Component)new TranslatableComponent("celestialexploration.planet_details.neptune_name"), new Vec2((float)CelestialUtil.getPlanetaryChunkCoordinates((int)8).f_82479_ * 16.0f, (float)CelestialUtil.getPlanetaryChunkCoordinates((int)8).f_82481_ * 16.0f), (Component)new TranslatableComponent("celestialexploration.planet_details.neptune_resources"), (Component)new TranslatableComponent("celestialexploration.planet_details.neptune_moons")));
    });

    public static int getFibonacciTerm(int n) {
        double squareRootOf5 = Math.sqrt(5.0);
        double phi = (1.0 + squareRootOf5) / 2.0;
        return (int)((Math.pow(phi, n) - Math.pow(-phi, -n)) / squareRootOf5);
    }

    public static int getSpaceRatio() {
        return (Integer)CelestialCommonConfig.RANGE_OF_SPACE.get();
    }

    public static Vec3 getPlanetaryChunkCoordinates(ResourceKey<Level> planet) {
        Vec3 coord = DIMENSION_LOCATION.get(planet);
        coord = new Vec3(coord.f_82479_ * (double)CelestialUtil.getSpaceRatio(), coord.f_82480_, coord.f_82481_ * (double)CelestialUtil.getSpaceRatio());
        return coord;
    }

    @Deprecated
    public static Vec3 getPlanetaryChunkCoordinates(String planet) {
        Vec3 coord = DIMENSION_LOCATION.get(planet);
        coord = new Vec3(coord.f_82479_ * (double)CelestialUtil.getSpaceRatio(), coord.f_82480_, coord.f_82481_ * (double)CelestialUtil.getSpaceRatio());
        return coord;
    }

    @Deprecated
    public static Vec3 getPlanetaryChunkCoordinates(int planetNum) {
        switch (planetNum) {
            case 1: {
                int x = 1;
                int z = 1;
                break;
            }
            case 2: {
                int x = 0;
                int z = 2;
                break;
            }
            case 3: {
                int x = -2;
                int z = 0;
                break;
            }
            case 4: {
                int x = 1;
                int z = -3;
                break;
            }
            case 5: {
                int x = 6;
                int z = 2;
                break;
            }
            case 6: {
                int x = -2;
                int z = 10;
                break;
            }
            case 7: {
                int x = -15;
                int z = -3;
                break;
            }
            case 8: {
                int x = 6;
                int z = -24;
                break;
            }
            default: {
                int x = 0;
                int z = 0;
            }
        }
        return new Vec3((double)(x *= CelestialUtil.getSpaceRatio()), 0.0, (double)(z *= CelestialUtil.getSpaceRatio()));
    }

    public static boolean isInRectangle(int centerX, int centerY, int radius, int x, int y) {
        return x >= centerX - radius && x <= centerX + radius && y >= centerY - radius && y <= centerY + radius;
    }

    public static boolean isInRectangle(double centerX, double centerY, int radius, double x, double y) {
        return x >= centerX - (double)radius && x <= centerX + (double)radius && y >= centerY - (double)radius && y <= centerY + (double)radius;
    }

    public static boolean isPointInCircle(int centerX, int centerY, int radius, int x, int y) {
        if (CelestialUtil.isInRectangle(centerX, centerY, radius, x, y)) {
            int distanceSquared;
            int dx = centerX - x;
            int dy = centerY - y;
            int radiusSquared = radius * radius;
            return (distanceSquared = (dx *= dx) + (dy *= dy)) <= radiusSquared;
        }
        return false;
    }

    public static int getCalculatedCircleRadius(double radius) {
        return (int)(radius * (double)CelestialUtil.getSpaceRatio());
    }

    public static int getIdFromFluid(FluidStack fluidStack) {
        if (fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76193_)) {
            return 1;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76195_)) {
            return 2;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)FluidRegistry.MOLTEN_IRON.get())) {
            return 3;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)FluidRegistry.MOLTEN_STEEL.get())) {
            return 4;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)FluidRegistry.MOLTEN_COPPER.get())) {
            return 5;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)FluidRegistry.MOLTEN_GOLD.get())) {
            return 6;
        }
        if (fluidStack.getFluid().m_6212_((Fluid)FluidRegistry.MOLTEN_ALUMINUM.get())) {
            return 8;
        }
        return 0;
    }

    public static FluidStack getFluidFromId(int id, int amount) {
        return switch (id) {
            case 1 -> new FluidStack((Fluid)Fluids.f_76193_, amount);
            case 2 -> new FluidStack((Fluid)Fluids.f_76195_, amount);
            case 3 -> new FluidStack((Fluid)FluidRegistry.MOLTEN_IRON.get(), amount);
            case 4 -> new FluidStack((Fluid)FluidRegistry.MOLTEN_STEEL.get(), amount);
            case 5 -> new FluidStack((Fluid)FluidRegistry.MOLTEN_COPPER.get(), amount);
            case 6 -> new FluidStack((Fluid)FluidRegistry.MOLTEN_GOLD.get(), amount);
            case 8 -> new FluidStack((Fluid)FluidRegistry.MOLTEN_ALUMINUM.get(), amount);
            default -> FluidStack.EMPTY;
        };
    }

    public static CelestialBodyDetails getPlanetDetail(int index) {
        return PLANET_DETAILS.get(index);
    }

    public record CelestialBodyDetails(Component name, Component location, Component resources, Component moons) {
        private static final Component coordinatesString = new TranslatableComponent("celestialexploration.planet_details.location");
        private static final Component moonsString = new TranslatableComponent("celestialexploration.planet_details.moons");
        private static final Component noMoons = new TranslatableComponent("celestialexploration.planet_details.no_moons");
        private static final Component resourcesString = new TranslatableComponent("celestialexploration.planet_details.resources");

        CelestialBodyDetails(Component name, Vec2 coordinates, Component resources) {
            this(name, coordinates, resources, noMoons);
        }

        CelestialBodyDetails(Component name, Vec2 coordinates, Component resources, Component moons) {
            this(name, (Component)new TextComponent(coordinatesString.getString() + ": " + (int)coordinates.f_82470_ + "," + (int)coordinates.f_82471_), (Component)new TextComponent(resourcesString.getString() + ": " + resources.getString()), (Component)new TextComponent(moonsString.getString() + ": " + moons.getString()));
        }
    }
}

