/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.util;

import com.google.common.collect.ImmutableList;
import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.registry.BlockRegistry;
import com.shim.celestialexploration.registry.DimensionRegistry;
import com.shim.celestialexploration.util.CelestialUtil;
import com.shim.celestialexploration.world.portal.CelestialTeleporter;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportUtil {
    private static final Map<ResourceKey<Level>, List<Block>> DIMENSION_STRUCTURE_BLOCKS = (Map)Util.m_137469_((Object)new Object2ObjectArrayMap(), dimension -> {
        dimension.put(DimensionRegistry.MERCURY, (Object)ImmutableList.builder().add((Object[])new Block[]{(Block)BlockRegistry.MERCURY_STONE.get(), (Block)BlockRegistry.MERCURY_DEEPSLATE.get(), (Block)BlockRegistry.MERCURY_CORE.get()}).build());
        dimension.put(DimensionRegistry.VENUS, (Object)ImmutableList.builder().add((Object[])new Block[]{(Block)BlockRegistry.VENUS_STONE.get(), Blocks.f_50204_, (Block)BlockRegistry.VENUS_DEEPSLATE.get(), (Block)BlockRegistry.VENUS_CORE.get()}).build());
        dimension.put((Object)Level.f_46428_, (Object)ImmutableList.builder().add((Object[])new Block[]{Blocks.f_50069_, Blocks.f_50062_, Blocks.f_50147_, Blocks.f_50440_, Blocks.f_50472_, Blocks.f_50211_, Blocks.f_50126_, Blocks.f_50354_, Blocks.f_152550_, Blocks.f_50752_}).build());
        dimension.put(DimensionRegistry.MOON, (Object)ImmutableList.builder().add((Object[])new Block[]{(Block)BlockRegistry.MOON_STONE.get(), (Block)BlockRegistry.MOON_DEEPSLATE.get(), (Block)BlockRegistry.MOON_CORE.get()}).build());
        dimension.put(DimensionRegistry.MARS, (Object)ImmutableList.builder().add((Object[])new Block[]{(Block)BlockRegistry.MARS_STONE.get(), (Block)BlockRegistry.MARS_DEEPSLATE.get(), (Block)BlockRegistry.MARS_CORE.get(), (Block)BlockRegistry.DRY_ICE.get()}).build());
    });
    private static final Map<ResourceKey<Level>, List<ResourceKey<Level>>> PLANET_MOONS = (Map)Util.m_137469_((Object)new Object2ObjectArrayMap(), dimension -> {
        dimension.put(DimensionRegistry.MERCURY, null);
        dimension.put(DimensionRegistry.VENUS, null);
        dimension.put((Object)Level.f_46428_, (Object)ImmutableList.builder().add(DimensionRegistry.MOON).build());
        dimension.put(DimensionRegistry.MARS, null);
    });

    public static void addDimensionStructureBlocks(ResourceKey<Level> dimension, List<Block> blocks) {
        DIMENSION_STRUCTURE_BLOCKS.put(dimension, blocks);
    }

    public static void addPlanetMoon(ResourceKey<Level> dimension, List<ResourceKey<Level>> moons) {
        PLANET_MOONS.put(dimension, moons);
    }

    public static ResourceKey<Level> getTeleportLocation(Vec3 location, BlockState blockWeSee) {
        ResourceKey<Level> planet = null;
        for (ResourceKey<Level> loc : CelestialUtil.DIMENSION_LOCATION.keySet()) {
            ChunkPos planetChunkPos = new ChunkPos((int)CelestialUtil.getPlanetaryChunkCoordinates(loc).f_82479_, (int)CelestialUtil.getPlanetaryChunkCoordinates(loc).f_82481_);
            ChunkPos chunkPos = new ChunkPos(new BlockPos(location.f_82479_, location.f_82480_, location.f_82481_));
            if (!CelestialUtil.isInRectangle(planetChunkPos.f_45578_, planetChunkPos.f_45579_, 4, chunkPos.f_45578_, chunkPos.f_45579_)) continue;
            planet = loc;
            break;
        }
        CelestialExploration.LOGGER.debug("");
        if (planet == null) {
            return null;
        }
        List<Block> blocksToComp = DIMENSION_STRUCTURE_BLOCKS.get(planet);
        if (blocksToComp == null) {
            return null;
        }
        for (Block block : blocksToComp) {
            if (!block.m_49966_().m_60713_(blockWeSee.m_60734_())) continue;
            return planet;
        }
        List<ResourceKey<Level>> moons = PLANET_MOONS.get(planet);
        if (moons != null) {
            for (ResourceKey resourceKey : moons) {
                blocksToComp = DIMENSION_STRUCTURE_BLOCKS.get(resourceKey);
                for (Block block : blocksToComp) {
                    if (!block.m_49966_().m_60713_(blockWeSee.m_60734_())) continue;
                    return resourceKey;
                }
            }
        }
        return null;
    }

    public static void teleport(Entity spaceVehicle, @Nullable ArrayList<Entity> passengers, ResourceKey<Level> destinationDim, Vec3 locationInPlace) {
        ServerLevel destinationWorld;
        Level entityWorld;
        MinecraftServer minecraftserver;
        if (spaceVehicle.m_6072_() && (minecraftserver = (entityWorld = spaceVehicle.f_19853_).m_142572_()) != null && (destinationWorld = minecraftserver.m_129880_(destinationDim)) != null) {
            if (destinationDim != DimensionRegistry.SPACE) {
                locationInPlace = new Vec3(locationInPlace.f_82479_, (double)(destinationWorld.m_151558_() - 10), locationInPlace.f_82481_);
            }
            if (!entityWorld.f_46443_) {
                ServerLevel level = (ServerLevel)spaceVehicle.m_183503_();
                level.m_46473_().m_6180_("placing");
                spaceVehicle.m_20219_(locationInPlace);
                if (passengers != null) {
                    for (Entity passenger : passengers) {
                        passenger.m_20219_(locationInPlace);
                    }
                }
                level.m_46473_().m_7238_();
            }
            Entity newSpaceVehicle = spaceVehicle.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
            if (passengers != null) {
                for (Entity passenger : passengers) {
                    Entity newPassenger = null;
                    if (passenger instanceof Player) {
                        passenger.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
                    } else {
                        newPassenger = passenger.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
                    }
                    if (entityWorld.f_46443_) continue;
                    assert (newSpaceVehicle != null);
                    if (passenger instanceof ServerPlayer) {
                        passenger.m_20329_(newSpaceVehicle);
                        continue;
                    }
                    if (newPassenger == null) continue;
                    newPassenger.m_20329_(newSpaceVehicle);
                }
            }
        }
    }

    public static void displayTeleportMessage(Entity entity, int teleportCooldown, ResourceKey<Level> destination) {
        if (entity instanceof Player) {
            if (teleportCooldown % 20 == 0 && teleportCooldown != 0) {
                ((Player)entity).m_5661_(Component.m_130674_((String)("Teleporting to " + destination.m_135782_().m_135815_().toUpperCase() + " in\u2026 " + teleportCooldown / 20)), true);
            } else if (teleportCooldown == 0) {
                ((Player)entity).m_5661_(Component.m_130674_((String)"Teleporting!"), true);
            }
        }
    }
}

