/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.shim.celestialexploration.registry.BiomeRegistry;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public class CelestialBiomeSource
extends BiomeSource {
    public static final Codec<CelestialBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(b -> b.seed), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(b -> b.biomes)).apply((Applicative)instance, instance.stable(CelestialBiomeSource::new)));
    private static final DecimalFormat DEBUG_DECIMAL_FORMAT = new DecimalFormat("0.000");
    private static Set<ResourceKey<Biome>> POSSIBLE_BIOMES = Stream.of(BiomeRegistry.MARS_CRATERS).map(RegistryObject::getKey).collect(Collectors.toSet());
    private final long seed;
    private final Registry<Biome> biomes;
    private final Climate.ParameterList<Holder<Biome>> parameters;

    public CelestialBiomeSource(long seed, Registry<Biome> biomes) {
        super(POSSIBLE_BIOMES.stream().map(arg_0 -> biomes.m_206081_(arg_0)));
        this.seed = seed;
        this.biomes = biomes;
        ImmutableList.Builder builder = ImmutableList.builder();
        this.parameters = new Climate.ParameterList((List)builder.build());
    }

    public static void register() {
        Registry.m_122965_((Registry)Registry.f_122889_, (ResourceLocation)new ResourceLocation("celestialexploration", "celestial_exploration"), CODEC);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeSource m_7206_(long seed) {
        return new CelestialBiomeSource(seed, this.biomes);
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        return (Holder)this.parameters.m_204252_(sampler.m_183445_(x, y, z));
    }
}

