/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.biome;

import com.shim.celestialexploration.registry.EntityRegistry;
import javax.annotation.Nullable;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class CelestialBiomes {
    @Nullable
    protected static final Music NORMAL_MUSIC = null;

    protected static int calculateSkyColor(float p_194844_) {
        float $$1 = p_194844_ / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    protected static Biome biome(Biome.Precipitation precipitation, Biome.BiomeCategory category, float temperature, float downfall, int skyColor, int fogColor, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47595_(category).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(skyColor).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome space() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.VOIDFELLOW.get(), 30, 0, 1)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.LURKER.get(), 5, 0, 1)).m_48381_();
        return CelestialBiomes.biome(Biome.Precipitation.NONE, Biome.BiomeCategory.NONE, -1.0f, 0.0f, celestialBody.SPACE.skyColor, celestialBody.SPACE.skyFogColor, celestialBody.SPACE.waterColor, celestialBody.SPACE.waterFogColor, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    protected static void generalMonsters(MobSpawnSettings.Builder spawnBuilder, int voidedCount, int skeletonCount, int lurkerCount) {
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.VOIDED.get(), voidedCount, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, skeletonCount, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.LURKER.get(), lurkerCount, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.VOIDFELLOW.get(), 10, 1, 4));
    }

    public static void addCarversAndLakes(BiomeGenerationSettings.Builder biomeBuilder) {
        biomeBuilder.m_204198_(GenerationStep.Carving.AIR, Carvers.f_126848_);
        biomeBuilder.m_204198_(GenerationStep.Carving.AIR, Carvers.f_194741_);
        biomeBuilder.m_204198_(GenerationStep.Carving.AIR, Carvers.f_126849_);
        biomeBuilder.m_204201_(GenerationStep.Decoration.LAKES, MiscOverworldPlacements.f_195266_);
    }

    public static enum celestialBody {
        SPACE(0, 0, 90, 329011),
        MARS(15565857, 14591603, 335425, 3150848),
        MOON(1807, 1549, 335425, 69408),
        VENUS(14200929, 10715456, 4741209, 3160378),
        MERCURY(1807, 1549, 335425, 69408);

        final int skyColor;
        final int skyFogColor;
        final int waterColor;
        final int waterFogColor;

        private celestialBody(int skyColor, int skyFogColor, int waterColor, int waterFogColor) {
            this.skyColor = skyColor;
            this.skyFogColor = skyFogColor;
            this.waterColor = waterColor;
            this.waterFogColor = waterFogColor;
        }
    }
}

