/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.gen;

import com.google.common.collect.ImmutableList;
import com.shim.celestialexploration.registry.BlockRegistry;
import com.shim.celestialexploration.world.biome.CelestialBiomeKeys;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;

public class CelestialSurfaceRules {
    private static final SurfaceRules.RuleSource AIR = CelestialSurfaceRules.makeStateRule(Blocks.f_50016_);
    private static final SurfaceRules.RuleSource BEDROCK = CelestialSurfaceRules.makeStateRule(Blocks.f_50752_);
    private static final SurfaceRules.RuleSource DRY_ICE = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.DRY_ICE.get());
    private static final SurfaceRules.RuleSource MARS_DEEPSLATE = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.MARS_DEEPSLATE.get());
    private static final SurfaceRules.RuleSource MARS_SAND = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.MARS_SAND.get());
    private static final SurfaceRules.RuleSource COARSE_MARS_SAND = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.COARSE_MARS_SAND.get());
    private static final SurfaceRules.RuleSource MOON_DEEPSLATE = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.MOON_DEEPSLATE.get());
    private static final SurfaceRules.RuleSource MOON_SAND = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.MOON_SAND.get());
    private static final SurfaceRules.RuleSource COARSE_MOON_SAND = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.COARSE_MOON_SAND.get());
    private static final SurfaceRules.RuleSource GLOWING_MOON_SAND = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.GLOWING_MOON_SAND.get());
    private static final SurfaceRules.RuleSource VENUS_DEEPSLATE = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.VENUS_DEEPSLATE.get());
    private static final SurfaceRules.RuleSource VENUS_SAND = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.VENUS_SAND.get());
    private static final SurfaceRules.RuleSource FINE_VENUS_SAND = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.FINE_VENUS_SAND.get());
    private static final SurfaceRules.RuleSource GEYSER = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.GEYSER.get());
    private static final SurfaceRules.RuleSource MERCURY_DEEPSLATE = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.MERCURY_DEEPSLATE.get());
    private static final SurfaceRules.RuleSource MERCURY_SAND = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.MERCURY_SAND.get());
    private static final SurfaceRules.RuleSource COARSE_MERCURY_SAND = CelestialSurfaceRules.makeStateRule((Block)BlockRegistry.COARSE_MERCURY_SAND.get());

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.m_189390_((BlockState)block.m_49966_());
    }

    public static SurfaceRules.RuleSource mars() {
        ImmutableList.Builder builder = ImmutableList.builder();
        SurfaceRules.ConditionSource dryIce = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{CelestialBiomeKeys.MARS_DRY_ICE_FLATS, CelestialBiomeKeys.MARS_DRY_ICE_FLATS});
        SurfaceRules.ConditionSource shallowSand = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{CelestialBiomeKeys.MARS_CRATERS, CelestialBiomeKeys.MARS_DEEP_CRATERS, CelestialBiomeKeys.MARS_ERODED_FLATS, CelestialBiomeKeys.MARS_FLATS, CelestialBiomeKeys.MARS_VOLCANO_FLATS});
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)dryIce, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)DRY_ICE))})));
        builder.add((Object)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)3, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)-0.9f, (double)-0.3f), (SurfaceRules.RuleSource)COARSE_MARS_SAND))}));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{CelestialBiomeKeys.MARS_DUNES}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)20, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)MARS_SAND))})));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{CelestialBiomeKeys.MARS_DESERT}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)3, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)MARS_SAND))})));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)shallowSand, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)MARS_SAND))})));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"deepslate", (VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)8)), (SurfaceRules.RuleSource)MARS_DEEPSLATE));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    public static SurfaceRules.RuleSource moon() {
        ImmutableList.Builder builder = ImmutableList.builder();
        SurfaceRules.ConditionSource shallowSand = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{CelestialBiomeKeys.MOON_PLAINS, CelestialBiomeKeys.MOON_LOWER_PLAINS, CelestialBiomeKeys.MOON_CRATERS, CelestialBiomeKeys.MOON_LAVA_FLATS});
        builder.add((Object)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189274_, (double)0.7f, (double)1.0), (SurfaceRules.RuleSource)GLOWING_MOON_SAND)))}));
        builder.add((Object)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189274_, (double)-1.0, (double)-0.8f), (SurfaceRules.RuleSource)GLOWING_MOON_SAND)))}));
        builder.add((Object)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)3, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)-0.9f, (double)-0.3f), (SurfaceRules.RuleSource)COARSE_MOON_SAND))}));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{CelestialBiomeKeys.MOON_DESERT}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)15, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)MOON_SAND))})));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)shallowSand, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)MOON_SAND))})));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"deepslate", (VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)8)), (SurfaceRules.RuleSource)MOON_DEEPSLATE));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    public static SurfaceRules.RuleSource venus() {
        ImmutableList.Builder builder = ImmutableList.builder();
        SurfaceRules.ConditionSource shallowSand = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{CelestialBiomeKeys.VENUS_PLAINS, CelestialBiomeKeys.VENUS_LOWER_PLAINS, CelestialBiomeKeys.VENUS_SULFUR_FLATS});
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{CelestialBiomeKeys.VENUS_DESERT}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)15, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)VENUS_SAND))})));
        builder.add((Object)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189274_, (double)0.9f, (double)1.0), (SurfaceRules.RuleSource)GEYSER)))}));
        builder.add((Object)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)-1.0, (double)-0.9f), (SurfaceRules.RuleSource)GEYSER)))}));
        builder.add((Object)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189274_, (double)-1.0, (double)-0.9f), (SurfaceRules.RuleSource)GEYSER)))}));
        builder.add((Object)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)3, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)-0.9f, (double)-0.3f), (SurfaceRules.RuleSource)FINE_VENUS_SAND))}));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)shallowSand, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)VENUS_SAND))})));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"deepslate", (VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)8)), (SurfaceRules.RuleSource)VENUS_DEEPSLATE));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    public static SurfaceRules.RuleSource mercury() {
        ImmutableList.Builder builder = ImmutableList.builder();
        SurfaceRules.ConditionSource shallowSand = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{CelestialBiomeKeys.MERCURY_CRATERED_PLAINS, CelestialBiomeKeys.MERCURY_DEEP_CRATERED_PLAINS, CelestialBiomeKeys.MERCURY_PLAINS, CelestialBiomeKeys.MERCURY_RIDGES});
        builder.add((Object)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)3, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)-0.9f, (double)-0.3f), (SurfaceRules.RuleSource)COARSE_MERCURY_SAND))}));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{CelestialBiomeKeys.MERCURY_DESERT}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)15, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)MERCURY_SAND))})));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)shallowSand, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)MERCURY_SAND))})));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"deepslate", (VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)8)), (SurfaceRules.RuleSource)MERCURY_DEEPSLATE));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    public static SurfaceRules.RuleSource space() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"air", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)AIR));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double p_194809_) {
        return SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)(p_194809_ / 8.25), (double)Double.MAX_VALUE);
    }
}

