/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.renderer;

import com.shim.celestialexploration.registry.DimensionRegistry;
import com.shim.celestialexploration.world.renderer.MarsSkyHandler;
import com.shim.celestialexploration.world.renderer.MarsWeatherHandler;
import com.shim.celestialexploration.world.renderer.MarsWeatherParticleHandler;
import com.shim.celestialexploration.world.renderer.MercurySkyHandler;
import com.shim.celestialexploration.world.renderer.MoonSkyHandler;
import com.shim.celestialexploration.world.renderer.SpaceSkyHandler;
import com.shim.celestialexploration.world.renderer.VenusWeatherHandler;
import com.shim.celestialexploration.world.renderer.VenusWeatherParticleHandler;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.client.IWeatherParticleRenderHandler;
import net.minecraftforge.client.IWeatherRenderHandler;

@OnlyIn(value=Dist.CLIENT)
public class DimensionRenderers {
    public static void setDimensionEffects() {
        DimensionSpecialEffects.f_108857_.put((Object)DimensionRegistry.MARS.m_135782_(), (Object)new MarsEffects());
        DimensionSpecialEffects.f_108857_.put((Object)DimensionRegistry.MOON.m_135782_(), (Object)new MoonEffects());
        DimensionSpecialEffects.f_108857_.put((Object)DimensionRegistry.SPACE.m_135782_(), (Object)new SpaceEffects());
        DimensionSpecialEffects.f_108857_.put((Object)DimensionRegistry.VENUS.m_135782_(), (Object)new VenusEffects());
        DimensionSpecialEffects.f_108857_.put((Object)DimensionRegistry.MERCURY.m_135782_(), (Object)new MercuryEffects());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MarsEffects
    extends DimensionSpecialEffects {
        ISkyRenderHandler skyHandler = new MarsSkyHandler();
        IWeatherRenderHandler weatherHandler = new MarsWeatherHandler();
        IWeatherParticleRenderHandler particleHandler = new MarsWeatherParticleHandler();
        private final float[] sunriseCol = new float[4];

        public MarsEffects() {
            super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            this.setSkyRenderHandler(this.skyHandler);
            this.setWeatherRenderHandler(this.weatherHandler);
            this.setWeatherParticleRenderHandler(this.particleHandler);
        }

        public boolean m_5781_(int x, int z) {
            return false;
        }

        public float[] m_7518_(float p_230492_1_, float p_230492_2_) {
            float f = 0.4f;
            float f1 = (float)(Math.cos(p_230492_1_ * ((float)Math.PI * 2)) - 0.0);
            float f2 = -0.0f;
            if (f1 >= -0.4f && f1 <= 0.4f) {
                float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
                float f4 = (float)(1.0 - (1.0 - Math.sin(f3 * (float)Math.PI)) * (double)0.99f);
                f4 *= f4;
                this.sunriseCol[0] = f3 * 0.3f - 5.7f;
                this.sunriseCol[1] = f3 * f3 * 0.7f + 3.2f;
                this.sunriseCol[2] = f3 * f3 * 0.0f + 3.2f;
                this.sunriseCol[3] = f4;
                return this.sunriseCol;
            }
            return null;
        }

        public Vec3 m_5927_(Vec3 color, float brightness) {
            return color.m_82542_((double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.91f + 0.09f));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MoonEffects
    extends DimensionSpecialEffects {
        ISkyRenderHandler skyHandler = new MoonSkyHandler();

        public MoonEffects() {
            super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            this.setSkyRenderHandler(this.skyHandler);
        }

        public Vec3 m_5927_(Vec3 color, float brightness) {
            return color.m_82542_((double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.91f + 0.09f));
        }

        public boolean m_5781_(int x, int z) {
            BlockPos pos = new BlockPos(x, 0, z);
            return false;
        }

        public float[] m_7518_(float p_230492_1_, float p_230492_2_) {
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SpaceEffects
    extends DimensionSpecialEffects {
        ISkyRenderHandler skyHandler = new SpaceSkyHandler();

        public SpaceEffects() {
            super(Float.NaN, false, DimensionSpecialEffects.SkyType.NONE, true, false);
            this.setSkyRenderHandler(this.skyHandler);
        }

        public boolean m_5781_(int x, int z) {
            return false;
        }

        public float[] m_7518_(float p_230492_1_, float p_230492_2_) {
            return null;
        }

        public Vec3 m_5927_(Vec3 color, float brightness) {
            return color;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VenusEffects
    extends DimensionSpecialEffects {
        VenusWeatherHandler weatherHandler = new VenusWeatherHandler();
        VenusWeatherParticleHandler particleHandler = new VenusWeatherParticleHandler();

        public VenusEffects() {
            super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, true);
            this.setWeatherRenderHandler(this.weatherHandler);
            this.setWeatherParticleRenderHandler(this.particleHandler);
        }

        public Vec3 m_5927_(Vec3 p_108901_, float p_108902_) {
            return p_108901_;
        }

        public boolean m_5781_(int x, int z) {
            return true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MercuryEffects
    extends DimensionSpecialEffects {
        ISkyRenderHandler skyHandler = new MercurySkyHandler();

        public MercuryEffects() {
            super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            this.setSkyRenderHandler(this.skyHandler);
        }

        public Vec3 m_5927_(Vec3 color, float brightness) {
            return color.m_82542_((double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.91f + 0.09f));
        }

        public boolean m_5781_(int x, int z) {
            return false;
        }

        public float[] m_7518_(float p_230492_1_, float p_230492_2_) {
            return null;
        }
    }
}

