/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.shim.celestialexploration.config.CelestialCommonConfig;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.client.IWeatherRenderHandler;

public class MarsWeatherHandler
implements IWeatherRenderHandler {
    ResourceLocation DUST_LOCATION = new ResourceLocation("celestialexploration", "textures/environment/dust.png");
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];

    MarsWeatherHandler() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = Mth.m_14116_((float)(f * f + f1 * f1));
                this.rainSizeX[i << 5 | j] = -f1 / f2;
                this.rainSizeZ[i << 5 | j] = f / f2;
            }
        }
    }

    public void render(int ticks, float partialTick, ClientLevel level, Minecraft minecraft, LightTexture lightTexture, double camX, double camY, double camZ) {
        if (!((Boolean)CelestialCommonConfig.STORMS.get()).booleanValue()) {
            return;
        }
        float f = level.m_46722_(partialTick);
        if (!(f <= 0.0f)) {
            lightTexture.m_109896_();
            int i = Mth.m_14107_((double)camX);
            int j = Mth.m_14107_((double)camY);
            int k = Mth.m_14107_((double)camZ);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            int l = Minecraft.m_91405_() ? 8 : 3;
            RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
            int i1 = -1;
            float f1 = (float)ticks + partialTick;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)this.rainSizeX[l1] * 0.5;
                    double d1 = (double)this.rainSizeZ[l1] * 0.5;
                    blockpos$mutableblockpos.m_122169_((double)k1, camY, (double)j1);
                    int i2 = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, k1, j1);
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = Math.max(i2, j);
                    if (j2 == k2) continue;
                    Random random = new Random((long)k1 * (long)k1 * 3121L + (long)k1 * 45238971L ^ (long)j1 * (long)j1 * 418711L + (long)j1 * 13761L);
                    blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                    if (i1 != 0) {
                        if (i1 >= 0) {
                            tesselator.m_85914_();
                        }
                        i1 = 0;
                        RenderSystem.m_157456_((int)0, (ResourceLocation)this.DUST_LOCATION);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    int i3 = ticks + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                    float f2 = -((float)i3 + partialTick) / 32.0f * (3.0f + random.nextFloat());
                    double d2 = (double)k1 + 0.5 - camX;
                    double d4 = (double)j1 + 0.5 - camZ;
                    float f3 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)l;
                    float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                    blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                    int j3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                    if (i1 != 1) {
                        if (i1 >= 0) {
                            tesselator.m_85914_();
                        }
                        i1 = 1;
                        RenderSystem.m_157456_((int)0, (ResourceLocation)this.DUST_LOCATION);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    float f5 = -((float)(ticks & 0x1FF) + partialTick) / 512.0f;
                    float f6 = (float)(random.nextDouble() + (double)f1 * 0.01 * (double)((float)random.nextGaussian()));
                    float f7 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.001);
                    double d3 = (double)k1 + 0.5 - camX;
                    double d5 = (double)j1 + 0.5 - camZ;
                    float f8 = (float)Math.sqrt(d3 * d3 + d5 * d5) / (float)l;
                    float f9 = ((1.0f - f8 * f8) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                    int k3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = k3 & 0xFFFF;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    double d6 = 0.5;
                    bufferbuilder.m_5483_((double)k1 - camX - d0 + d6, (double)k2 - camY, (double)j1 - camZ - d1 + d6).m_7421_(0.0f + f6, (float)j2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - camX + d0 + d6, (double)k2 - camY, (double)j1 - camZ + d1 + d6).m_7421_(1.0f + f6, (float)j2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - camX + d0 + 0.5, (double)j2 - camY, (double)j1 - camZ + d1 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - camX - d0 + 0.5, (double)j2 - camY, (double)j1 - camZ - d1 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                }
            }
            if (i1 >= 0) {
                tesselator.m_85914_();
            }
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
            lightTexture.m_109891_();
        }
    }
}

