/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.structures;

import com.mojang.serialization.Codec;
import com.shim.celestialexploration.registry.BlockRegistry;
import com.shim.celestialexploration.world.features.ResearchTunnelConfiguration;
import com.shim.celestialexploration.world.structures.ResearchTunnelPieces;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.QuartPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class ResearchTunnelStructure
extends StructureFeature<ResearchTunnelConfiguration> {
    public ResearchTunnelStructure() {
        super(ResearchTunnelConfiguration.CODEC, PieceGeneratorSupplier.m_197349_(ResearchTunnelStructure::checkLocation, ResearchTunnelStructure::generatePieces), PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    public static boolean checkLocation(PieceGeneratorSupplier.Context<ResearchTunnelConfiguration> context) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        double d0 = ((ResearchTunnelConfiguration)context.f_197356_()).probability;
        return !(worldgenrandom.nextDouble() >= d0) && context.f_197358_().test(context.f_197352_().m_203495_(QuartPos.m_175400_((int)context.f_197355_().m_151390_()), QuartPos.m_175400_((int)50), QuartPos.m_175400_((int)context.f_197355_().m_151393_())));
    }

    public static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<ResearchTunnelConfiguration> context) {
        ResearchTunnelPieces.ResearchTunnelRoom tunnelpieces$tunnelroom = new ResearchTunnelPieces.ResearchTunnelRoom(0, (Random)context.f_192708_(), context.f_192705_().m_151382_(2), context.f_192705_().m_151391_(2), ((ResearchTunnelConfiguration)context.f_197328_()).type);
        builder.m_142679_((StructurePiece)tunnelpieces$tunnelroom);
        tunnelpieces$tunnelroom.m_142537_(tunnelpieces$tunnelroom, (StructurePieceAccessor)builder, (Random)context.f_192708_());
        int i = context.f_192703_().m_6337_();
        builder.m_192783_(i, context.f_192703_().m_142062_(), (Random)context.f_192708_(), 10);
    }

    public static enum Type implements StringRepresentable
    {
        MARS("mars", (Block)BlockRegistry.MARS_BRICKS.get(), (Block)BlockRegistry.MARS_BRICKS.get(), (Block)BlockRegistry.MARS_BRICK_WALL.get()),
        MOON("moon", (Block)BlockRegistry.MOON_BRICKS.get(), (Block)BlockRegistry.MOON_BRICKS.get(), (Block)BlockRegistry.MOON_BRICK_WALL.get()),
        VENUS("venus", (Block)BlockRegistry.VENUS_BRICKS.get(), (Block)BlockRegistry.VENUS_BRICKS.get(), (Block)BlockRegistry.VENUS_BRICK_WALL.get()),
        MERCURY("mercury", (Block)BlockRegistry.MERCURY_BRICKS.get(), (Block)BlockRegistry.MERCURY_BRICKS.get(), (Block)BlockRegistry.MERCURY_BRICK_WALL.get());

        public static final Codec<Type> CODEC;
        private static final Map<String, Type> BY_NAME;
        private final String name;
        private final BlockState woodState;
        private final BlockState planksState;
        private final BlockState fenceState;

        private Type(String name, Block woodState, Block plank, Block fence) {
            this.name = name;
            this.woodState = woodState.m_49966_();
            this.planksState = plank.m_49966_();
            this.fenceState = fence.m_49966_();
        }

        public String getName() {
            return this.name;
        }

        private static Type byName(String name) {
            return BY_NAME.get(name);
        }

        public static Type byId(int id) {
            return id >= 0 && id < Type.values().length ? Type.values()[id] : MOON;
        }

        public BlockState getWoodState() {
            return this.woodState;
        }

        public BlockState getPlanksState() {
            return this.planksState;
        }

        public BlockState getFenceState() {
            return this.fenceState;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_14350_(Type::values, Type::byName);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, p_66333_ -> p_66333_));
        }
    }
}

