/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.api.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TeleportValidator {
    public static boolean isValidTeleportPosition(Entity entity, BlockPos pos) {
        Level level = entity.level();
        if (level.getBlockState(pos).getBlock() != Blocks.AIR) {
            return false;
        }
        BlockPos blockBelow = pos.below();
        BlockState stateBelow = level.getBlockState(blockBelow);
        if (stateBelow.getBlock() == Blocks.AIR || stateBelow.getBlock() == Blocks.LAVA || stateBelow.getBlock() == Blocks.WATER) {
            return false;
        }
        AABB boundingBox = new AABB((double)pos.getX() - 0.5, (double)pos.getY(), (double)pos.getZ() - 0.5, (double)pos.getX() + 0.5, (double)((float)pos.getY() + entity.getBbHeight()), (double)pos.getZ() + 0.5);
        return level.noCollision(entity, boundingBox);
    }

    public static boolean isBetterPosition(Entity entity, BlockPos pos, BlockPos bestPos) {
        double bestDistance;
        double currentDistance = entity.position().distanceTo(Vec3.atCenterOf((Vec3i)pos));
        return currentDistance < (bestDistance = entity.position().distanceTo(Vec3.atCenterOf((Vec3i)bestPos)));
    }
}

