/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.block;

import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.xylonity.knightquest.common.block.tracker.ChaliceBlockTracker;
import net.xylonity.knightquest.common.entity.boss.NethermanEntity;
import net.xylonity.knightquest.config.values.KQConfigValues;
import net.xylonity.knightquest.registry.KnightQuestBlocks;
import net.xylonity.knightquest.registry.KnightQuestEntities;
import net.xylonity.knightquest.registry.KnightQuestItems;
import net.xylonity.knightquest.registry.KnightQuestParticles;
import org.jetbrains.annotations.NotNull;

public class ChaliceBlock
extends Block {
    public static final IntegerProperty fill = IntegerProperty.create((String)"level", (int)1, (int)9);
    private static final VoxelShape SHAPE_N = Stream.of(Block.box((double)0.0, (double)7.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)2.0, (double)7.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), Block.box((double)2.0, (double)7.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public ChaliceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE_N;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{fill});
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        Block block = pLevel.getBlockState(pPos).getBlock();
        ItemStack stack = pPlayer.getItemInHand(pHand);
        Item item = stack.getItem();
        if (block.equals(KnightQuestBlocks.GREAT_CHALICE.get()) && item.equals(KnightQuestItems.GREAT_ESSENCE.get()) && Arrays.asList(1, 2, 3, 4).contains(pState.getValue((Property)fill)) && !pLevel.isClientSide()) {
            double centerX = (double)pPos.getX() + 0.5;
            double centerZ = (double)pPos.getZ() + 0.5;
            double initialY = (double)pPos.getY() + 0.1;
            double particleY = initialY - 0.48;
            ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket((ParticleOptions)((SimpleParticleType)KnightQuestParticles.STARSET_PARTICLE.get()), true, centerX, particleY, centerZ, 0.0f, 0.0f, 0.0f, 1.0f, 1);
            if (pLevel instanceof ServerLevel) {
                pLevel.getServer().getPlayerList().broadcast(null, centerX, particleY, centerZ, 50.0, pLevel.dimension(), (Packet)packet);
            }
            pLevel.playSound(null, pPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)fill), 3);
            if (pPlayer.getItemInHand(pHand).getCount() > 1) {
                int count = stack.getCount();
                stack.setCount(--count);
            } else {
                pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)ItemStack.EMPTY.getItem()));
            }
            if ((Integer)pState.getValue((Property)fill) == 4) {
                pLevel.playSound(null, pPos, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (block.equals(KnightQuestBlocks.GREAT_CHALICE.get()) && item.equals(KnightQuestItems.EMPTY_GOBLET.get()) && ((Integer)pState.getValue((Property)fill)).equals(5)) {
            if (pLevel.isClientSide()) {
                double radius = 0.5;
                double centerX = (double)pPos.getX() + 0.5;
                double centerZ = (double)pPos.getZ() + 0.5;
                double initialY = pPos.getY();
                for (int i = 0; i < 360; i += 12) {
                    double angleRadians = Math.toRadians(i);
                    double particleX = centerX + radius * Math.cos(angleRadians);
                    double particleZ = centerZ + radius * Math.sin(angleRadians);
                    pLevel.addParticle((ParticleOptions)ParticleTypes.EFFECT, particleX, initialY + 1.0, particleZ, -0.5, 0.5, 0.5);
                }
            }
            if (!pLevel.isClientSide()) {
                pLevel.playSound(null, pPos, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (pPlayer.getItemInHand(pHand).getCount() > 1) {
                    int stackCount = stack.getCount();
                    stack.setCount(--stackCount);
                } else {
                    pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)ItemStack.EMPTY.getItem()));
                }
                ItemEntity entity = new ItemEntity(pLevel, (double)pPos.getX() + 0.5, (double)pPos.getY() + 1.0, (double)pPos.getZ() + 0.5, ((Item)KnightQuestItems.FILLED_GOBLET.get()).getDefaultInstance());
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)fill, (Comparable)Integer.valueOf(1)), 3);
                pLevel.addFreshEntity((Entity)entity);
            }
        }
        if (block.equals(KnightQuestBlocks.GREAT_CHALICE.get()) && item.equals(KnightQuestItems.RADIANT_ESSENCE.get()) && ((Integer)pState.getValue((Property)fill)).equals(5) && KQConfigValues.CAN_SUMMON_NETHERMAN && !pLevel.isClientSide()) {
            if (pPlayer.getItemInHand(pHand).getCount() > 1) {
                int stackCount = stack.getCount();
                stack.setCount(--stackCount);
            } else {
                pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)ItemStack.EMPTY.getItem()));
            }
            pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)fill), 3);
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    public void animateTick(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        if (((Integer)pState.getValue((Property)fill)).equals(5) && pLevel.isClientSide()) {
            double radius = 0.37;
            double centerX = (double)pPos.getX() + 0.5;
            double centerZ = (double)pPos.getZ() + 0.5;
            double initialY = (double)pPos.getY() - 0.5;
            for (int i = 0; i < 360; i += 60) {
                double angleRadians = Math.toRadians(i);
                double particleX = centerX + radius * Math.cos(angleRadians);
                double particleZ = centerZ + radius * Math.sin(angleRadians);
                pLevel.addParticle((ParticleOptions)ParticleTypes.EFFECT, particleX, initialY + 1.0, particleZ, 0.0, 0.35, 0.0);
            }
        }
        super.animateTick(pState, pLevel, pPos, pRandom);
    }

    public void tick(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        int tickCount = ChaliceBlockTracker.getTickCount(pPos);
        if (Arrays.asList(6, 7, 8, 9).contains(pState.getValue((Property)fill))) {
            if (tickCount == 0) {
                pLevel.playSound(null, pPos, SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (tickCount % 10 == 0 && (Integer)pState.getValue((Property)fill) != 9 && tickCount < 60) {
                pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)fill), 3);
                pLevel.playSound(null, pPos, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (tickCount == 60) {
                NethermanEntity entity;
                pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)fill), 3);
                LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)pLevel);
                if (lightningBolt != null && KQConfigValues.SPAWN_LIGHTNING_ON_SPAWN) {
                    lightningBolt.moveTo((double)pPos.getX() + 0.5, (double)pPos.getY(), (double)pPos.getZ() + 0.5);
                    pLevel.addFreshEntity((Entity)lightningBolt);
                }
                if ((entity = (NethermanEntity)((EntityType)KnightQuestEntities.NETHERMAN.get()).create((Level)pLevel)) != null) {
                    entity.moveTo((float)pPos.getX() + 0.5f, pPos.getY() + 1, (float)pPos.getZ() + 0.5f);
                    pLevel.addFreshEntity((Entity)entity);
                }
                ChaliceBlockTracker.resetTickCount(pPos);
            } else {
                ChaliceBlockTracker.incrementTickCount(pPos);
            }
            this.scheduleTick((Level)pLevel, pPos);
        }
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (!pLevel.isClientSide) {
            ChaliceBlockTracker.addChalice(pPos, this);
            this.scheduleTick(pLevel, pPos);
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pLevel.isClientSide) {
            ChaliceBlockTracker.removeChalice(pPos);
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    private void scheduleTick(Level pLevel, BlockPos pPos) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            serverLevel.scheduleTick(pPos, (Block)this, 1);
        }
    }
}

