/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.block.tracker;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.xylonity.knightquest.common.block.ChaliceBlock;

public class ChaliceBlockTracker {
    private static final Map<BlockPos, ChaliceBlock> chaliceMap = new HashMap<BlockPos, ChaliceBlock>();
    private static final Map<BlockPos, Integer> tickCounts = new HashMap<BlockPos, Integer>();

    public static void addChalice(BlockPos pos, ChaliceBlock chaliceBlock) {
        chaliceMap.put(pos, chaliceBlock);
        tickCounts.put(pos, 0);
    }

    public static void removeChalice(BlockPos pos) {
        chaliceMap.remove(pos);
        tickCounts.remove(pos);
    }

    public static int getTickCount(BlockPos pos) {
        return tickCounts.getOrDefault(pos, 0);
    }

    public static void incrementTickCount(BlockPos pos) {
        tickCounts.put(pos, ChaliceBlockTracker.getTickCount(pos) + 1);
    }

    public static ChaliceBlock getChalice(BlockPos pos) {
        return chaliceMap.get(pos);
    }

    public static void resetTickCount(BlockPos pos) {
        tickCounts.put(pos, 0);
    }
}

