/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.entity.boss;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.xylonity.knightquest.common.api.explosiveenhancement.ExplosiveConfig;
import net.xylonity.knightquest.common.api.util.ParticleGenerator;
import net.xylonity.knightquest.common.api.util.TeleportValidator;
import net.xylonity.knightquest.common.entity.boss.ai.MagicProjectileAttackGoal;
import net.xylonity.knightquest.common.entity.boss.ai.NethermanAttackGoal;
import net.xylonity.knightquest.common.entity.boss.ai.NethermanFlameGoal;
import net.xylonity.knightquest.common.entity.boss.ai.NethermanLavaTeleportGoal;
import net.xylonity.knightquest.common.entity.boss.ai.SpawnNethermanClonesGoal;
import net.xylonity.knightquest.config.values.KQConfigValues;
import net.xylonity.knightquest.registry.KnightQuestParticles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NethermanEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(Objects.requireNonNull(this.getDisplayName()), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private static final EntityDataAccessor<Byte> PHASE = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> INVULNERABLE = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final Map<BlockPos, BlockState> changedBlocks = new HashMap<BlockPos, BlockState>();
    private int explosionPower = 1;
    private int tickCounterFirstPhaseSwitch = 0;
    private int tickCounterSecondPhaseSwitch = 0;
    private boolean hasChangedPhase = false;
    private boolean hasChangedSecondPhase = false;
    private boolean specialAttack = false;
    private int specialAttackCounter = 0;
    private boolean noMovement = false;
    private boolean weatherChanged = false;
    private boolean weatherReverted = false;

    public NethermanEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 350.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.7f).add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.KNOCKBACK_RESISTANCE, 5.0).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new NethermanAttackGoal(this, 0.5, true));
        this.goalSelector.addGoal(2, (Goal)new NethermanLavaTeleportGoal(this));
        this.goalSelector.addGoal(3, (Goal)new NethermanFlameGoal(this));
        this.goalSelector.addGoal(2, (Goal)new SpawnNethermanClonesGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MagicProjectileAttackGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean getInvulnerability() {
        return (Boolean)this.entityData.get(INVULNERABLE);
    }

    public void setInvulnerability(boolean invulnerability) {
        this.entityData.set(INVULNERABLE, (Object)invulnerability);
    }

    public int getPhase() {
        return ((Byte)this.entityData.get(PHASE)).byteValue();
    }

    public void setPhase(int phase) {
        this.entityData.set(PHASE, (Object)((byte)phase));
    }

    public void setCharging(boolean pCharging) {
        this.entityData.set(DATA_IS_CHARGING, (Object)pCharging);
    }

    public boolean getIsAttacking() {
        return (Boolean)this.entityData.get(IS_ATTACKING);
    }

    public void setIsAttacking(boolean attacking) {
        this.entityData.set(IS_ATTACKING, (Object)attacking);
    }

    public void tick() {
        super.tick();
        if (this.isOnFire() && this.getPhase() == 1) {
            this.extinguishFire();
        }
        float progress = this.getHealth() / this.getMaxHealth();
        this.bossInfo.setProgress(progress);
        if (this.getPhase() == 3 && this.tickCount % KQConfigValues.LIGHTNING_TICK_INTERVAL == 0 && KQConfigValues.LIGHTNING_STRIKE_IN_PHASE_THREE) {
            this.summonLightning();
        }
        if (this.noMovement) {
            this.getNavigation().stop();
            this.setDeltaMovement(Vec3.ZERO);
        }
        if (this.tickCount == 1) {
            if (KQConfigValues.GENERATE_PARTICLES_ON_SUMMON) {
                ExplosiveConfig.spawnParticles(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), 4.0f, false, false, 0);
            }
            this.level().playSound(null, this.blockPosition(), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (this.getHealth() < this.getMaxHealth() * 0.66f && this.getPhase() == 1) {
            ++this.tickCounterFirstPhaseSwitch;
            if (!this.hasChangedPhase) {
                this.setNoMovement(true);
                boolean bl = this.hasChangedPhase = !this.hasChangedPhase;
            }
            if (this.tickCounterFirstPhaseSwitch == 0) {
                ExplosiveConfig.spawnParticles(this.level(), this.getX(), this.getY(), this.getZ(), 3.0f, false, false, 1);
            }
            if (this.tickCounterFirstPhaseSwitch < 195) {
                this.winterStormAttack();
            } else {
                this.setNoMovement(false);
                this.level().playSound(null, this.blockPosition(), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
                ExplosiveConfig.spawnParticles(this.level(), this.getX(), this.getY(), this.getZ(), 4.0f, false, false, 1);
                this.setPhase(2);
            }
        }
        if (this.getHealth() < this.getMaxHealth() * 0.33f) {
            ++this.tickCounterSecondPhaseSwitch;
            if (!this.hasChangedSecondPhase) {
                ServerLevel serverLevel;
                Level level;
                this.setInvulnerability(true);
                this.setNoMovement(true);
                boolean bl = this.hasChangedSecondPhase = !this.hasChangedSecondPhase;
                if (!this.weatherChanged && (level = this.level()) instanceof ServerLevel && !(serverLevel = (ServerLevel)level).isThundering()) {
                    serverLevel.setWeatherParameters(0, 24000, true, true);
                    boolean bl2 = this.weatherChanged = !this.weatherChanged;
                }
            }
        }
        if (this.tickCounterSecondPhaseSwitch == 85) {
            ExplosiveConfig.spawnParticles(this.level(), this.getX(), this.getY() + 3.5, this.getZ(), 4.0f, false, false, 2);
            this.setPhase(3);
            this.level().playSound(null, this.blockPosition(), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (this.tickCounterSecondPhaseSwitch == 145) {
            this.setNoMovement(false);
            this.setInvulnerability(false);
        }
        if (this.specialAttack) {
            if (this.specialAttackCounter == 20) {
                this.level().playLocalSound(this.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                ParticleGenerator.specialAttackParticles((Entity)this, 80, 0.3, 2.0, 0.0, (ParticleOptions)ParticleTypes.CLOUD);
                Vec3 vec3 = this.position().add(0.0, (double)1.6f, 0.0);
                Vec3 vec31 = this.getEyePosition().subtract(vec3);
                Vec3 vec32 = vec31.normalize();
                for (int i = 1; i < Mth.floor((double)vec31.length()) + 7; ++i) {
                    Vec3 vec33 = vec3.add(vec32.scale((double)i));
                    this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, vec33.x, vec33.y - 2.0, vec33.z, 1.0, 0.0, 0.0);
                }
            }
            if (this.specialAttackCounter == 34) {
                this.level().playLocalSound(this.blockPosition(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                ParticleGenerator.specialAttackParticles((Entity)this, 20, 0.05, 2.0, 0.005, (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE);
                this.specialAttack = !this.specialAttack;
                this.specialAttackCounter = 0;
                this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(5.0)).forEach(player -> {
                    Vec3 direction = player.position().subtract(this.position()).normalize().scale(1.5);
                    player.push(direction.x, direction.y + 0.5, direction.z);
                });
                this.setInvulnerability(false);
            }
            ++this.specialAttackCounter;
        }
    }

    private void teleportAroundTarget() {
        BlockPos bestPos = null;
        LivingEntity target = this.getTarget();
        RandomSource random = this.getRandom();
        for (int attempt = 0; attempt < 50 && target != null; ++attempt) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double distance = 5.0 + random.nextDouble() * 15.0;
            double x = target.getX() + Math.cos(angle) * distance;
            double z = target.getZ() + Math.sin(angle) * distance;
            double y = target.getY() + (random.nextDouble() - 0.5) * 2.0;
            BlockPos targetPos = new BlockPos((int)x, (int)y, (int)z);
            if (TeleportValidator.isValidTeleportPosition((Entity)this, targetPos)) {
                for (Player player : this.level().players()) {
                    if (!(player instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    for (int u = 0; u < 20; ++u) {
                        serverPlayer.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.PORTAL, true, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (float)((this.random.nextDouble() - 0.5) * 2.0), (float)(-this.random.nextDouble()), 0.2f, 0.0f, 1));
                    }
                }
                this.level().playSound(null, this.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.teleportTo(x, y, z);
                this.level().playSound(null, this.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.0f);
                return;
            }
            if (bestPos != null && !TeleportValidator.isBetterPosition((Entity)this, targetPos, bestPos)) continue;
            bestPos = targetPos;
        }
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        if (this.getInvulnerability() || (pSource.is(DamageTypes.ON_FIRE) || pSource.is(DamageTypes.IN_FIRE) || pSource.is(DamageTypes.LAVA)) && this.getPhase() == 1 || pSource.is(DamageTypes.LIGHTNING_BOLT) && this.getPhase() == 3 || pSource.is(DamageTypes.EXPLOSION) || pSource.is(DamageTypes.PLAYER_EXPLOSION) || this.tickCount < 40) {
            return false;
        }
        boolean isDamaged = super.hurt(pSource, pAmount);
        if (isDamaged && pAmount < this.getHealth() && (double)this.getRandom().nextFloat() <= KQConfigValues.TELEPORT_PROBABILITY) {
            this.teleportAroundTarget();
        }
        return isDamaged;
    }

    private void restoreBlocks() {
        for (Map.Entry<BlockPos, BlockState> entry : this.changedBlocks.entrySet()) {
            this.level().setBlock(entry.getKey(), entry.getValue(), 3);
        }
        this.changedBlocks.clear();
    }

    public void die(@NotNull DamageSource pDamageSource) {
        super.die(pDamageSource);
        if (KQConfigValues.RESTORE_BLOCKS_POST_DEATH) {
            this.restoreBlocks();
        }
    }

    public void saveBlockState(BlockPos pos) {
        if (!this.changedBlocks.containsKey(pos)) {
            BlockState state = this.level().getBlockState(pos);
            this.changedBlocks.put(pos, state);
        }
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    public AnimationController<?> getPhaseController() {
        return (AnimationController)this.cache.getManagerForId((long)this.getId()).getAnimationControllers().get("phasecontroller");
    }

    private void winterStormAttack() {
        double range = KQConfigValues.WINTER_STORM_RADIUS;
        AABB area = new AABB(this.getX() - range, this.getY() - range, this.getZ() - range, this.getX() + range, this.getY() + range, this.getZ() + range);
        List players = this.level().getEntitiesOfClass(Player.class, area);
        for (Player player : players) {
            if (!this.hasLineOfSight((Entity)player)) continue;
            player.setTicksFrozen(player.getTicksFrozen() + KQConfigValues.FROZEN_TICKS);
        }
        int particleCount = KQConfigValues.SNOW_PARTICLE_COUNT;
        double particleSpeed = KQConfigValues.SNOW_PARTICLE_SPEED;
        double time = (double)this.tickCount / 20.0;
        for (int i = 0; i < particleCount; ++i) {
            double offset = (double)i * 0.1;
            double angle = Math.PI * 2 * (double)i / (double)particleCount + time;
            double velocityX = particleSpeed * Math.cos(angle + offset);
            double velocityZ = particleSpeed * Math.sin(angle + offset);
            double velocityY = 0.5 * Math.sin(Math.PI * 2 * (double)i / (double)particleCount + time);
            double particleX = this.getX();
            double particleY = this.getY() + 2.2;
            double particleZ = this.getZ();
            this.level().addParticle((ParticleOptions)KnightQuestParticles.SNOWFLAKE_PARTICLE.get(), particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
        }
        if (this.tickCount % 4 == 0) {
            this.level().playLocalSound(this.blockPosition(), SoundEvents.WARDEN_ATTACK_IMPACT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public void setNoMovement(boolean noMovement) {
        this.noMovement = noMovement;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WARDEN_DEATH;
    }

    private void summonLightning() {
        double offsetZ;
        double offsetX;
        BlockPos lightningPos;
        Random random = new Random();
        do {
            offsetX = (random.nextDouble() - 0.5) * 2.0 * 20.0;
            offsetZ = (random.nextDouble() - 0.5) * 2.0 * 20.0;
        } while ((lightningPos = this.blockPosition().offset((int)offsetX, 0, (int)offsetZ)).closerThan((Vec3i)this.blockPosition(), 2.0));
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverLevel);
            assert (lightningBolt != null);
            lightningBolt.moveTo((double)lightningPos.getX(), (double)lightningPos.getY(), (double)lightningPos.getZ());
            serverLevel.addFreshEntity((Entity)lightningBolt);
        }
    }

    protected void tickDeath() {
        Level level;
        ++this.deathTime;
        if (!this.weatherReverted && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.setWeatherParameters(0, 0, false, false);
            boolean bl = this.weatherReverted = !this.weatherReverted;
        }
        if (this.level() instanceof ServerLevel && this.deathTime > 0 && this.deathTime % 5 == 0) {
            int award = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (Player)this.lastHurtByPlayer, (int)Mth.floor((float)((float)KQConfigValues.EXPERIENCE_DROP_AMOUNT * 0.08f)));
            ExperienceOrb.award((ServerLevel)((ServerLevel)this.level()), (Vec3)this.position(), (int)award);
        }
        if (this.deathTime >= 40 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(PHASE, (Object)1);
        pBuilder.define(DATA_IS_CHARGING, (Object)false);
        pBuilder.define(INVULNERABLE, (Object)false);
        pBuilder.define(IS_ATTACKING, (Object)false);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (this.hasCustomName()) {
            this.bossInfo.setName(Objects.requireNonNull(this.getDisplayName()));
        }
        if (pCompound.contains("ExplosionPower", 99)) {
            this.explosionPower = pCompound.getByte("ExplosionPower");
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackcontroller", 0, this::attackPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "phasecontroller", 0, this::secondPhasePredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "rotationcontroller", 0, this::rotationPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "deadcontroller", 0, this::deadPredicate));
    }

    private PlayState deadPredicate(AnimationState<?> event) {
        if (this.isDeadOrDying()) {
            event.getController().setAnimation(RawAnimation.begin().then("dead", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState rotationPredicate(AnimationState<?> event) {
        if (this.getHealth() < this.getMaxHealth() * 0.66f && !this.hasChangedPhase) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("rotation", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState secondPhasePredicate(AnimationState<?> event) {
        if (this.getHealth() < this.getMaxHealth() * 0.33f && !this.hasChangedSecondPhase) {
            event.getController().setAnimation(RawAnimation.begin().then("phase_switch", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.getIsAttacking() && ((double)this.getHealth() > (double)this.getMaxHealth() * 0.7 || (double)this.getHealth() < (double)this.getMaxHealth() * 0.6 && (double)this.getHealth() > (double)this.getMaxHealth() * 0.45 || (double)this.getHealth() < (double)this.getMaxHealth() * 0.3)) {
            event.getController().setAnimation(RawAnimation.begin().then("teleport_charge", Animation.LoopType.PLAY_ONCE));
        } else if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.swinging && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            String attackPattern;
            event.getController().forceAnimationReset();
            switch (this.random.nextInt(11)) {
                case 0: 
                case 1: 
                case 2: {
                    String string = "attack";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    String string = "attack2";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    String string = "attack3";
                    break;
                }
                default: {
                    String string = attackPattern = "specialAttack";
                }
            }
            if (attackPattern.equals("specialAttack") && this.getPhase() != 3 && ((double)this.getHealth() > (double)this.getMaxHealth() * 0.7 || (double)this.getHealth() < (double)this.getMaxHealth() * 0.6 && (double)this.getHealth() > (double)this.getMaxHealth() * 0.4)) {
                this.specialAttack = true;
                event.getController().setAnimation(RawAnimation.begin().then("attack_teleport1", Animation.LoopType.PLAY_ONCE).then("attack_teleport2", Animation.LoopType.PLAY_ONCE));
            } else {
                event.getController().setAnimation(RawAnimation.begin().then(attackPattern, Animation.LoopType.PLAY_ONCE));
            }
            this.swinging = false;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setCustomName(@Nullable Component pName) {
        super.setCustomName(pName);
        this.bossInfo.setName(Objects.requireNonNull(this.getDisplayName()));
    }

    public void startSeenByPlayer(@NotNull ServerPlayer pPlayer) {
        super.startSeenByPlayer(pPlayer);
        this.bossInfo.addPlayer(pPlayer);
    }

    public void stopSeenByPlayer(@NotNull ServerPlayer pPlayer) {
        super.stopSeenByPlayer(pPlayer);
        this.bossInfo.removePlayer(pPlayer);
    }
}

