/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.entity.boss;

import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.xylonity.knightquest.common.api.explosiveenhancement.ExplosiveConfig;
import net.xylonity.knightquest.common.entity.boss.AbstractNethermanProjectile;
import net.xylonity.knightquest.common.entity.boss.NethermanEntity;
import net.xylonity.knightquest.registry.KnightQuestEntities;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NethermanTeleportChargeEntity
extends AbstractNethermanProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int explosionPower = 1;
    private boolean hasCollided = false;
    private int ticksUntilDiscard = 0;
    private float rotationAngle = 0.0f;

    public NethermanTeleportChargeEntity(EntityType<? extends AbstractNethermanProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setNoGravity(true);
    }

    public float getRotationAngle() {
        return this.rotationAngle;
    }

    public NethermanTeleportChargeEntity(Level pLevel, LivingEntity pShooter, double pOffsetX, double pOffsetY, double pOffsetZ, int pExplosionPower) {
        super((EntityType<? extends AbstractNethermanProjectile>)((EntityType)KnightQuestEntities.NETHERMAN_TELEPORT_CHARGE.get()), pShooter, pOffsetX, pOffsetY, pOffsetZ, pLevel);
        this.explosionPower = pExplosionPower;
    }

    protected void onHit(@NotNull HitResult pResult) {
        super.onHit(pResult);
        if (pResult instanceof EntityHitResult) {
            Entity hitEntity;
            EntityHitResult entityHitResult = (EntityHitResult)pResult;
            if (this.tickCount < 10 && (hitEntity = entityHitResult.getEntity()) instanceof NethermanEntity) {
                return;
            }
        }
        if (!this.level().isClientSide && !this.hasCollided) {
            this.level().playSound(null, this.getOnPos(), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.hasCollided = true;
        }
        if (this.level().isClientSide && !this.hasCollided) {
            this.createCustomExplosionParticles();
        }
        this.explode();
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putByte("ExplosionPower", (byte)this.explosionPower);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("ExplosionPower", 99)) {
            this.explosionPower = pCompound.getByte("ExplosionPower");
        }
    }

    private void explode() {
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, this.damageSources().generic(), null, this.getX(), this.getY(), this.getZ(), 2.0f, false, Level.ExplosionInteraction.NONE, false, (ParticleOptions)ParticleTypes.SMOKE, (ParticleOptions)ParticleTypes.SMOKE, (Holder)SoundEvents.NOTE_BLOCK_BELL);
            this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(4.0)).forEach(player -> {
                double randomX = this.getX() + (this.random.nextDouble() - 0.5) * 10.0;
                double randomZ = this.getZ() + (this.random.nextDouble() - 0.5) * 10.0;
                player.teleportTo(randomX, player.getY() + (double)new Random().nextInt(15, 25), randomZ);
            });
            this.ticksUntilDiscard = 2;
        }
    }

    private void createCustomExplosionParticles() {
        ExplosiveConfig.spawnParticles(this.level(), this.getX(), this.getY(), this.getZ(), 3.0f, false, false, 2);
        this.hasCollided = !this.hasCollided;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticksUntilDiscard > 0) {
            --this.ticksUntilDiscard;
            if (this.ticksUntilDiscard <= 0) {
                this.discard();
            }
        }
        this.rotationAngle += 6.0f;
        if (this.rotationAngle >= 360.0f) {
            this.rotationAngle -= 360.0f;
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("default", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

