/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.entity.boss.ai;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.xylonity.knightquest.common.entity.boss.NethermanCloneEntity;
import net.xylonity.knightquest.common.entity.boss.NethermanEntity;
import net.xylonity.knightquest.registry.KnightQuestEntities;

public class SpawnNethermanClonesGoal
extends Goal {
    private final NethermanEntity netherman;
    public int chargeTime;

    public SpawnNethermanClonesGoal(NethermanEntity netherman) {
        this.netherman = netherman;
    }

    public boolean canUse() {
        return this.netherman.getTarget() != null;
    }

    public void start() {
        this.chargeTime = 400;
    }

    public void stop() {
        this.netherman.setCharging(false);
        this.chargeTime = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity livingentity = this.netherman.getTarget();
        if (livingentity != null && this.netherman.getPhase() == 2) {
            if (livingentity.distanceToSqr((Entity)this.netherman) < 4096.0 && this.netherman.hasLineOfSight((Entity)livingentity)) {
                if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                if (this.chargeTime == 30) {
                    this.netherman.setNoMovement(true);
                    this.netherman.setIsAttacking(true);
                }
                if (this.chargeTime == 10) {
                    Vec3 position = this.netherman.position();
                    this.netherman.level().playSound(null, this.netherman.blockPosition(), SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.BLOCKS, 1.0f, 1.0f);
                    for (int i = 0; i < 4; ++i) {
                        double angle = this.netherman.getRandom().nextDouble() * 2.0 * Math.PI;
                        double distance = this.netherman.getRandom().nextDouble() * 30.0;
                        double xOffset = Math.cos(angle) * distance;
                        double zOffset = Math.sin(angle) * distance;
                        Vec3 spawnPos = position.add(xOffset, 0.0, zOffset);
                        NethermanCloneEntity nethermanClone = (NethermanCloneEntity)((EntityType)KnightQuestEntities.NETHERMAN_CLONE.get()).create(this.netherman.level());
                        assert (nethermanClone != null);
                        nethermanClone.moveTo(spawnPos.x, position.y, spawnPos.z);
                        this.netherman.level().addFreshEntity((Entity)nethermanClone);
                        for (Player player : this.netherman.level().players()) {
                            if (!(player instanceof ServerPlayer)) continue;
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            for (int u = 0; u < 20; ++u) {
                                serverPlayer.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, true, nethermanClone.getRandomX(0.5), nethermanClone.getRandomY() - 0.25, nethermanClone.getRandomZ(0.5), (float)((nethermanClone.getRandom().nextDouble() - 0.5) * 2.0), (float)(-nethermanClone.getRandom().nextDouble()), 0.2f, 0.0f, 2));
                            }
                        }
                        this.netherman.level().playSound(null, nethermanClone.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
                if (this.chargeTime == 0) {
                    this.netherman.setNoMovement(false);
                    this.netherman.setIsAttacking(false);
                    this.chargeTime = 400;
                }
            } else {
                this.chargeTime = 400;
            }
            this.netherman.setCharging(this.chargeTime > 0);
        } else {
            this.chargeTime = 400;
        }
    }
}

