/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.entity.client;

import net.minecraft.resources.ResourceLocation;
import net.xylonity.knightquest.common.entity.boss.NethermanEntity;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class NethermanModel
extends GeoModel<NethermanEntity> {
    public ResourceLocation getModelResource(NethermanEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"geo/netherman.geo.json");
    }

    public ResourceLocation getTextureResource(NethermanEntity animatable) {
        String path = switch (animatable.getPhase()) {
            case 1 -> "textures/entity/netherman_fire.png";
            case 2 -> "textures/entity/netherman_ice.png";
            default -> "textures/entity/netherman_magic.png";
        };
        return ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)path);
    }

    public ResourceLocation getAnimationResource(NethermanEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"animations/netherman.animation.json");
    }

    public void setCustomAnimations(NethermanEntity animatable, long instanceId, AnimationState<NethermanEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

