/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.xylonity.knightquest.common.entity.client.SwampmanAxeModel;
import net.xylonity.knightquest.common.entity.entities.SwampmanAxeEntity;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class SwampmanAxeRenderer
extends GeoEntityRenderer<SwampmanAxeEntity> {
    public SwampmanAxeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new SwampmanAxeModel());
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull SwampmanAxeEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"textures/entity/swampman.png");
    }

    public void vertex(PoseStack.Pose pPose, VertexConsumer pConsumer, int pX, int pY, int pZ, float pU, float pV, int pNormalX, int pNormalZ, int pNormalY, int pPackedLight) {
        pConsumer.addVertex(pPose, (float)pX, (float)pY, (float)pZ).setColor(255, 255, 255, 255).setUv(pU, pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(pPackedLight).setNormal(pPose, (float)pNormalX, (float)pNormalZ, (float)pNormalY);
    }

    public void render(SwampmanAxeEntity entity, float entityYaw, float partialTick, PoseStack pPoseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)entity.yRotO, (float)entity.getYRot()) + 90.0f));
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot())));
        float f9 = (float)entity.shakeTime - partialTick;
        if (f9 > 0.0f) {
            float f10 = -Mth.sin((float)(f9 * 3.0f)) * f9;
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(f10));
        }
        super.render((Entity)entity, entityYaw, partialTick, pPoseStack, bufferSource, packedLight);
        pPoseStack.popPose();
    }
}

