/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.entity.entities;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.xylonity.knightquest.common.entity.entities.GremlinEntity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GhastlingEntity
extends Monster
implements GeoEntity {
    private AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Level serverWorld;
    private static final double RADIUS = 2.0;
    private static final double ANGULAR_SPEED = 0.1;
    private double angle;

    public GhastlingEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.serverWorld = world;
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.63f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        return PlayState.CONTINUE;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        this.serverWorld.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY() + 0.5, this.getZ(), 1.2, 0.0, 0.0);
        this.level().playSound(null, this.blockPosition(), SoundEvents.VEX_HURT, SoundSource.HOSTILE, 1.0f, 1.0f);
        this.serverWorld.getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(3.0)).forEach(player -> {
            Vec3 direction = player.position().subtract(this.position()).normalize().scale(0.4);
            player.push(direction.x, direction.y + 0.5, direction.z);
        });
        this.remove(Entity.RemovalReason.KILLED);
        return false;
    }

    protected InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        return super.mobInteract(pPlayer, pHand);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void tick() {
        super.tick();
        GremlinEntity owner = this.findClosestGremlin();
        if (owner == null || owner.isDeadOrDying() || owner.getPhase() == 1) {
            this.remove(Entity.RemovalReason.KILLED);
            return;
        }
        Vec3 ownerPos = owner.position();
        double offsetX = Math.cos(this.angle) * 2.0;
        double offsetZ = Math.sin(this.angle) * 2.0;
        double offsetY = Math.sin(this.angle * 2.0) * 0.5;
        this.setPos(ownerPos.x() + offsetX, ownerPos.y() + 0.5 + offsetY, ownerPos.z() + offsetZ);
        if (this.level().getNearestPlayer((Entity)this, -1.0) != null) {
            this.lookAt((Entity)Objects.requireNonNull(this.level().getNearestPlayer((Entity)this, -1.0)), 360.0f, 360.0f);
        }
        this.angle += 0.1;
        if (this.angle >= Math.PI * 2) {
            this.angle -= Math.PI * 2;
        }
        SimpleParticleType particleType = ParticleTypes.SMOKE;
        for (int i = 0; i < 2; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particleType, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d0, d1, d2);
        }
    }

    protected void pushEntities() {
    }

    public void push(Entity pEntity) {
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean isInLava() {
        return false;
    }

    public boolean isInWater() {
        return false;
    }

    public boolean isInWall() {
        return false;
    }

    protected void spawnSprintParticle() {
    }

    private GremlinEntity findClosestGremlin() {
        double closestDistance = Double.MAX_VALUE;
        GremlinEntity closestGremlin = null;
        for (GremlinEntity entity : this.level().getEntitiesOfClass(GremlinEntity.class, this.getBoundingBox().inflate(4.0))) {
            double distance;
            if (!(entity instanceof GremlinEntity) || !((distance = this.distanceToSqr((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestGremlin = entity;
        }
        return closestGremlin;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent getSwimSound() {
        return null;
    }

    protected SoundEvent getDeathSound() {
        return null;
    }

    public void playSound(SoundEvent pSound) {
    }

    public void playSound(SoundEvent pSound, float pVolume, float pPitch) {
    }

    public boolean isNoGravity() {
        return true;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected void playHurtSound(DamageSource pSource) {
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return null;
    }

    protected void playStepSound(BlockPos pPos, BlockState pState) {
    }
}

