/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.entity.entities;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.xylonity.knightquest.common.entity.entities.GhastlingEntity;
import net.xylonity.knightquest.common.entity.entities.ai.NearestAttackableTargetGoal;
import net.xylonity.knightquest.config.values.KQConfigValues;
import net.xylonity.knightquest.registry.KnightQuestEntities;
import net.xylonity.knightquest.registry.KnightQuestParticles;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GremlinEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> IS_PASSIVE = SynchedEntityData.defineId(GremlinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SHOULD_TAKE_COIN = SynchedEntityData.defineId(GremlinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> GOLD_VARIATION = SynchedEntityData.defineId(GremlinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.defineId(GremlinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.defineId(GremlinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int tickCounterShield = 0;
    private int tickCounter = 0;
    private boolean isHalfHealth;

    public GremlinEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        if (!this.level().isClientSide()) {
            boolean attack1 = this.getRandom().nextBoolean();
            this.entityData.set(ATTACK, (Object)attack1);
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(IS_PASSIVE, (Object)false);
        pBuilder.define(SHOULD_TAKE_COIN, (Object)false);
        pBuilder.define(GOLD_VARIATION, (Object)0);
        pBuilder.define(PHASE, (Object)1);
        pBuilder.define(ATTACK, (Object)false);
    }

    public boolean getIsPassive() {
        return (Boolean)this.entityData.get(IS_PASSIVE);
    }

    public boolean getShouldTakeCoin() {
        return (Boolean)this.entityData.get(SHOULD_TAKE_COIN);
    }

    public int getGoldVariation() {
        return (Integer)this.entityData.get(GOLD_VARIATION);
    }

    public int getPhase() {
        return (Integer)this.entityData.get(PHASE);
    }

    public boolean getAttack() {
        return (Boolean)this.entityData.get(ATTACK);
    }

    public void setIsPassive(boolean isPassive) {
        this.entityData.set(IS_PASSIVE, (Object)isPassive);
    }

    public void setShouldTakeCoin(boolean shouldTakeCoin) {
        this.entityData.set(SHOULD_TAKE_COIN, (Object)shouldTakeCoin);
    }

    public void setGoldVariation(int goldVariation) {
        this.entityData.set(GOLD_VARIATION, (Object)goldVariation);
    }

    public void setPhase(int phase) {
        this.entityData.set(PHASE, (Object)phase);
    }

    public void setAttack(boolean attack) {
        this.entityData.set(ATTACK, (Object)attack);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 35.0).add(Attributes.ATTACK_DAMAGE, 5.5).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.63f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    private void updateAttributes() {
        Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(this.getAttributeValue(Attributes.ATTACK_DAMAGE) * (double)KQConfigValues.MULTIPLIER_GREMLIN_ATTACK_DAMAGE);
        Objects.requireNonNull(this.getAttribute(Attributes.MOVEMENT_SPEED)).setBaseValue(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)KQConfigValues.MULTIPLIER_GREMLIN_MOVEMENT_SPEED);
        Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_SPEED)).setBaseValue(this.getAttributeValue(Attributes.ATTACK_SPEED) * (double)KQConfigValues.MULTIPLIER_GREMLIN_ATTACK_SPEED);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.5, true));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 0.5, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}), false));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new NearestAttackableTargetGoal<Player>(this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "attackcontroller", 0, this::attackPredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "deadcontroller", 0, this::deadPredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "coincontroller", 0, this::coinPredicate));
    }

    private PlayState coinPredicate(AnimationState<?> event) {
        if (this.getIsPassive() && this.getShouldTakeCoin()) {
            event.getController().forceAnimationReset();
            String goldVariation = this.getGoldVariation() == 0 ? "gold" : "gold2";
            event.getController().setAnimation(RawAnimation.begin().then(goldVariation, Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState deadPredicate(AnimationState<?> event) {
        if (this.isDeadOrDying()) {
            event.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.swinging && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            this.swinging = false;
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void tick() {
        super.tick();
        if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.5) {
            if (!this.isHalfHealth) {
                this.level().addParticle((ParticleOptions)KnightQuestParticles.GREMLIN_PARTICLE.get(), this.getX(), this.getY() - 0.48, this.getZ(), 2.0, 0.0, 0.0);
                this.level().playSound(null, this.blockPosition(), SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.isHalfHealth = true;
                if (this.getAttack()) {
                    this.spawnShield();
                } else {
                    this.updateAttributes();
                }
                this.setPhase(2);
            }
            if (this.getAttack()) {
                ++this.tickCounterShield;
                if (this.tickCounterShield % 22 == 0 && this.tickCounterShield / 25 <= 1) {
                    this.spawnShield();
                }
            }
        }
        if (this.getIsPassive()) {
            ++this.tickCounter;
            if (this.tickCounter == 1) {
                this.setShouldTakeCoin(true);
            } else if (this.tickCounter == 3) {
                this.setShouldTakeCoin(false);
            } else if (this.tickCounter == 80) {
                this.setIsPassive(false);
                this.setShouldTakeCoin(false);
                this.tickCounter = 0;
            }
        }
    }

    private void spawnShield() {
        GhastlingEntity entity = (GhastlingEntity)((EntityType)KnightQuestEntities.SHIELD.get()).create(this.level());
        if (entity != null) {
            entity.moveTo(this.getOnPos(), 1.0f, 0.0f);
            this.level().addFreshEntity((Entity)entity);
        }
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (KQConfigValues.CAN_TAKE_GOLD_GREMLIN) {
            ItemStack itemstack = pPlayer.getItemInHand(pHand);
            Item desiredItem = Items.GOLD_INGOT;
            Item item = itemstack.getItem();
            if (item.equals(desiredItem)) {
                this.setTarget(null);
                this.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
                this.getBrain().eraseMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER);
                this.setLastHurtByMob(null);
                this.setLastHurtByPlayer(null);
                this.setGoldVariation(this.getRandom().nextInt(0, 2));
                this.setIsPassive(true);
            }
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        if (this.tickCounter != 0) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    protected SoundEvent getSwimSound() {
        return SoundEvents.AXOLOTL_SWIM;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.VEX_DEATH;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return SoundEvents.VEX_HURT;
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }
}

