/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.entity.entities;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RatmanEntity
extends Skeleton
implements GeoEntity {
    private AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Level serverWorld;
    private boolean summoned = false;
    private int counter = 0;
    private int arrowRotation = 50;
    private static final EntityDataAccessor<Boolean> ATTACK1 = SynchedEntityData.defineId(RatmanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public RatmanEntity(EntityType<? extends Skeleton> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.serverWorld = pLevel;
        if (!this.serverWorld.isClientSide()) {
            boolean attack1 = new Random().nextBoolean();
            this.entityData.set(ATTACK1, (Object)attack1);
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ATTACK1, (Object)false);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("attack1", this.getAttack1());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setAttack1(compound.getBoolean("attack1"));
    }

    public boolean getAttack1() {
        return (Boolean)this.entityData.get(ATTACK1);
    }

    public void setAttack1(boolean attack1) {
        this.entityData.set(ATTACK1, (Object)attack1);
    }

    public static AttributeSupplier setAttributes() {
        return Skeleton.createMobAttributes().add(Attributes.MAX_HEALTH, 22.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, 0.5).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RangedBowAttackGoal((Monster)this, 0.7, 10, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.BABY_ON_LAND_SELECTOR));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "attackcontroller", 0, this::attackPredicate));
    }

    public boolean canFireProjectileWeapon(@NotNull ProjectileWeaponItem pProjectileWeapon) {
        return pProjectileWeapon == Items.CROSSBOW;
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.isUsingItem()) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.AXOLOTL_SWIM;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.FOX_DEATH;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return SoundEvents.FOX_HURT;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.FOX_AMBIENT;
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    public void tick() {
        super.tick();
        if (this.getAttack1()) {
            if (!this.summoned && (double)this.getHealth() < (double)this.getMaxHealth() * 0.5) {
                if (this.counter < 10 && this.counter % 2 == 0) {
                    for (int i = 0; i < 2; ++i) {
                        this.shootArrow(this.arrowRotation += 36);
                    }
                }
                ++this.counter;
                if (this.counter >= 10) {
                    this.summoned = true;
                }
            }
        } else if (!this.summoned && (double)this.getHealth() < (double)this.getMaxHealth() * 0.5) {
            this.smokeBomb();
            this.summoned = true;
        }
    }

    private void shootArrow(int angle) {
        double arrowX = Math.cos(Math.toRadians(angle));
        double arrowY = this.getEyeY();
        double arrowZ = Math.sin(Math.toRadians(angle));
        Arrow arrow = new Arrow(this.serverWorld, (LivingEntity)this, new ItemStack((ItemLike)Items.ARROW), new ItemStack((ItemLike)Items.CROSSBOW));
        arrow.setPos(this.getX() + arrowX, arrowY - 1.5, this.getZ() + arrowZ);
        arrow.shotFromCrossbow();
        double velX = Math.cos(Math.toRadians(angle));
        double velZ = Math.sin(Math.toRadians(angle));
        arrow.setDeltaMovement(velX, 0.3, velZ);
        arrow.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 1));
        this.serverWorld.playSound(null, this.blockPosition(), SoundEvents.DISPENSER_LAUNCH, SoundSource.HOSTILE, 0.75f, 1.0f);
        this.serverWorld.addFreshEntity((Entity)arrow);
    }

    private void smokeBomb() {
        double radius = 2.5;
        this.serverWorld.playSound(null, this.blockPosition(), SoundEvents.SPLASH_POTION_BREAK, SoundSource.HOSTILE, 1.0f, 1.0f);
        for (int i = 0; i < 450; ++i) {
            double u = this.random.nextDouble();
            double v = this.random.nextDouble();
            double theta = Math.PI * 2 * u;
            double phi = Math.acos(2.0 * v - 1.0);
            double scale = Math.cbrt(this.random.nextDouble());
            double x = this.getX() + radius * scale * Math.sin(phi) * Math.cos(theta);
            double y = this.getY() + radius * scale * Math.sin(phi) * Math.sin(theta);
            double z = this.getZ() + radius * scale * Math.cos(phi);
            this.serverWorld.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, 0.0, 0.0, 0.0);
        }
        this.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 100, 1));
    }
}

