/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.entity.entities.ai;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.xylonity.knightquest.common.entity.entities.SamhainEntity;

public class MoveToPumpkinGoal
extends Goal {
    private final SamhainEntity entity;
    private final double speed;
    private BlockPos targetPumpkinPos;
    private final int searchRadius = 10;
    private final double circleRadius = 3.0;
    private double angle = 0.0;
    private final double angleIncrement = 0.39269908169872414;
    private final Random random = new Random();
    private int ticksCircling = 0;
    private final int maxTicksCircling = 80;

    public MoveToPumpkinGoal(SamhainEntity entity, double speed) {
        this.entity = entity;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        BlockPos entityPos = this.entity.blockPosition();
        Level level = this.entity.level();
        this.targetPumpkinPos = this.findNearestPumpkin(level, entityPos, 10);
        return this.targetPumpkinPos != null;
    }

    public boolean canContinueToUse() {
        return this.targetPumpkinPos != null && this.entity.level().getBlockState(this.targetPumpkinPos).is(Blocks.PUMPKIN);
    }

    public void start() {
        if (this.targetPumpkinPos != null) {
            this.moveToNextPosition();
            this.ticksCircling = 0;
        }
    }

    public void stop() {
        this.targetPumpkinPos = null;
    }

    public void tick() {
        if (this.targetPumpkinPos != null) {
            if (this.ticksCircling < 80) {
                if (this.entity.getNavigation().isDone()) {
                    this.angle += 0.39269908169872414;
                    this.moveToNextPosition();
                }
                ++this.ticksCircling;
                if (this.random.nextInt(20) == 0) {
                    this.entity.getJumpControl().jump();
                }
            } else {
                this.entity.getNavigation().moveTo((double)this.targetPumpkinPos.getX() + 0.5, (double)this.targetPumpkinPos.getY(), (double)this.targetPumpkinPos.getZ() + 0.5, this.speed);
            }
        }
    }

    private void moveToNextPosition() {
        double xOffset = (double)this.targetPumpkinPos.getX() + 3.0 * Math.cos(this.angle);
        double zOffset = (double)this.targetPumpkinPos.getZ() + 3.0 * Math.sin(this.angle);
        this.entity.getLookControl().setLookAt((double)this.targetPumpkinPos.getX(), (double)this.targetPumpkinPos.getY(), (double)this.targetPumpkinPos.getZ());
        this.entity.getNavigation().moveTo(xOffset, (double)this.targetPumpkinPos.getY(), zOffset, this.speed);
    }

    private BlockPos findNearestPumpkin(Level level, BlockPos entityPos, int radius) {
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)entityPos.offset(-radius, -2, -radius), (BlockPos)entityPos.offset(radius, 2, radius))) {
            if (!level.getBlockState(pos).is(Blocks.PUMPKIN)) continue;
            return pos;
        }
        return null;
    }
}

