/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.event;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.xylonity.knightquest.common.entity.boss.NethermanCloneEntity;
import net.xylonity.knightquest.common.entity.boss.NethermanEntity;
import net.xylonity.knightquest.common.entity.entities.BadPatchEntity;
import net.xylonity.knightquest.common.entity.entities.EldBombEntity;
import net.xylonity.knightquest.common.entity.entities.EldKnightEntity;
import net.xylonity.knightquest.common.entity.entities.GhastlingEntity;
import net.xylonity.knightquest.common.entity.entities.GhostyEntity;
import net.xylonity.knightquest.common.entity.entities.GremlinEntity;
import net.xylonity.knightquest.common.entity.entities.LizzyEntity;
import net.xylonity.knightquest.common.entity.entities.MommaLizzyEntity;
import net.xylonity.knightquest.common.entity.entities.RatmanEntity;
import net.xylonity.knightquest.common.entity.entities.SamhainEntity;
import net.xylonity.knightquest.common.entity.entities.SwampmanEntity;
import net.xylonity.knightquest.datagen.KQGlobalLootModifiersProvider;
import net.xylonity.knightquest.registry.KnightQuestEntities;

@Mod.EventBusSubscriber(modid="knightquest", bus=Mod.EventBusSubscriber.Bus.MOD)
public class KQEventRegisters {
    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)KnightQuestEntities.GREMLIN.get(), GremlinEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.ELDBOMB.get(), EldBombEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.ELDKINGHT.get(), EldKnightEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.SWAMPMAN.get(), SwampmanEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.RATMAN.get(), RatmanEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.SAMHAIN.get(), SamhainEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.LIZZY.get(), LizzyEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.BADPATCH.get(), BadPatchEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.SHIELD.get(), GhastlingEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.MOMMA_LIZZY.get(), MommaLizzyEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.GHOSTY.get(), GhostyEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.NETHERMAN.get(), NethermanEntity.setAttributes());
        event.put((EntityType)KnightQuestEntities.NETHERMAN_CLONE.get(), NethermanCloneEntity.setAttributes());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)KnightQuestEntities.BADPATCH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)KnightQuestEntities.ELDBOMB.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)KnightQuestEntities.ELDKINGHT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)KnightQuestEntities.GHOSTY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)KnightQuestEntities.GREMLIN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)KnightQuestEntities.LIZZY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)KnightQuestEntities.RATMAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)KnightQuestEntities.SAMHAIN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)KnightQuestEntities.SWAMPMAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeServer(), (DataProvider)new KQGlobalLootModifiersProvider(packOutput, "knightquest", event.getLookupProvider()));
    }
}

