/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.xylonity.knightquest.common.item.KQFullSetChecker;
import net.xylonity.knightquest.common.material.KQArmorMaterials;
import net.xylonity.knightquest.config.values.KQConfigValues;
import net.xylonity.knightquest.registry.KnightQuestItems;
import org.jetbrains.annotations.NotNull;

public class KQArmorItem
extends ArmorItem {
    private static final MobEffectInstance SHIELD_ARMOR = new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, -1, 0, false, false, true);
    private static final MobEffectInstance BAT_ARMOR = new MobEffectInstance(MobEffects.NIGHT_VISION, -1, 0, false, false, true);
    private static final MobEffectInstance PATH_ARMOR = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, -1, 1, false, true, true);
    private static final MobEffectInstance BOW_ARMOR = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, -1, 1, false, false, true);
    private static final MobEffectInstance HORN_ARMOR = new MobEffectInstance(MobEffects.DAMAGE_BOOST, 400, 1, false, false, true);
    private static final MobEffectInstance SEA_ARMOR = new MobEffectInstance(MobEffects.DOLPHINS_GRACE, -1, 0, false, false, true);
    private static final MobEffectInstance PIRATE_ARMOR = new MobEffectInstance(MobEffects.LUCK, -1, 0, false, false, true);
    private static final MobEffectInstance SPIDER_ARMOR = new MobEffectInstance(MobEffects.JUMP, -1, 1, false, false, false);
    private static final MobEffectInstance PHATOM_ARMOR = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, -1, 0, false, false, true);
    private static final MobEffectInstance NETHER_ARMOR = new MobEffectInstance(MobEffects.FIRE_RESISTANCE, -1, 0, false, false, true);
    private static final MobEffectInstance HUSK_ARMOR = new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, -1, 1, false, false, true);
    private static final MobEffectInstance BAMBOO_BLUE = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, -1, 1, false, false, true);
    private static final MobEffectInstance SILVERFISH_ARMOR = new MobEffectInstance(MobEffects.DIG_SPEED, -1, 0, false, false, true);
    private static final MobEffectInstance SKULK_ARMOR = new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, -1, 1, false, false, true);
    private static final MobEffectInstance STRAWHAT_ARMOR = new MobEffectInstance(MobEffects.WATER_BREATHING, -1, 0, false, false, true);
    private final String bonusTooltip;
    private final boolean hasTooltip;
    private static final Map<UUID, Map<Holder<ArmorMaterial>, Boolean>> effectAppliedByArmorMap = new HashMap<UUID, Map<Holder<ArmorMaterial>, Boolean>>();
    private static final Map<UUID, Boolean> doubleJumpStates = new HashMap<UUID, Boolean>();

    public KQArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings.stacksTo(1).durability(type.getDurability(37)));
        this.bonusTooltip = KQArmorMaterials.getKeyNameFromMaterial(material);
        this.hasTooltip = true;
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        if (this.hasTooltip) {
            if (!Objects.equals(this.bonusTooltip, "knightquest.chainmail") && !Objects.equals(this.bonusTooltip, "knightquest.tengu")) {
                pTooltipComponents.add((Component)Component.translatable((String)"tooltip.item.knightquest.full_set_bonus"));
                pTooltipComponents.add((Component)Component.translatable((String)("tooltip.item." + this.bonusTooltip + "_helmet.bonus")));
            } else if (Objects.equals(this.bonusTooltip, "knightquest.tengu")) {
                pTooltipComponents.add((Component)Component.translatable((String)"tooltip.item.knightquest.full_helmet_bonus"));
                pTooltipComponents.add((Component)Component.translatable((String)("tooltip.item." + this.bonusTooltip + "_helmet.bonus")));
            }
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    public void onInventoryTick(ItemStack stack, @NotNull Level level, Player player, int slotIndex, int selectedIndex) {
        if (!level.isClientSide()) {
            UUID playerUUID = player.getUUID();
            if (KQConfigValues.PATHSET) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.PATHSET) && player.isShiftKeyDown()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.PATHSET, false))) {
                        player.addEffect(PATH_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PATHSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.PATHSET, false))) {
                    player.removeEffect(MobEffects.MOVEMENT_SPEED);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PATHSET, false);
                }
            }
            if (KQConfigValues.BOWSET) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.BOWSET) && player.getMainHandItem().getItem() instanceof ProjectileWeaponItem) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.BOWSET, false))) {
                        player.addEffect(BOW_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BOWSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.BOWSET, false))) {
                    player.removeEffect(MobEffects.MOVEMENT_SPEED);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BOWSET, false);
                }
            }
            if (KQConfigValues.BATSET) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.BATSET) && level.isNight()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.BATSET, false))) {
                        player.addEffect(BAT_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BATSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.BATSET, false))) {
                    player.removeEffect(MobEffects.NIGHT_VISION);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BATSET, false);
                }
            }
            if (KQConfigValues.SHIELDSET) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.SHIELDSET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.SHIELDSET, false))) {
                        player.addEffect(SHIELD_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SHIELDSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.SHIELDSET, false))) {
                    player.removeEffect(MobEffects.DAMAGE_RESISTANCE);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SHIELDSET, false);
                }
            }
            if (KQConfigValues.PHANTOMSET) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.PHANTOMSET) && level.isNight()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.PHANTOMSET, false))) {
                        player.addEffect(PHATOM_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PHANTOMSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.PHANTOMSET, false))) {
                    player.removeEffect(MobEffects.MOVEMENT_SPEED);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PHANTOMSET, false);
                }
            }
            if (KQConfigValues.HORNSET) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.HORNSET) && player.getLastAttacker() != null) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.HORNSET, false))) {
                        player.addEffect(HORN_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.HORNSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.HORNSET, false))) {
                    player.removeEffect(MobEffects.DAMAGE_BOOST);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.HORNSET, false);
                }
            }
            if (KQConfigValues.SEASET) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.SEASET) && player.isUnderWater()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.SEASET, false))) {
                        player.addEffect(SEA_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SEASET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.SEASET, false))) {
                    player.removeEffect(MobEffects.DOLPHINS_GRACE);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SEASET, false);
                }
            }
            if (KQConfigValues.PIRATESET) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.PIRATESET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.PIRATESET, false))) {
                        player.addEffect(PIRATE_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PIRATESET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.PIRATESET, false))) {
                    player.removeEffect(MobEffects.LUCK);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PIRATESET, false);
                }
            }
            if (KQConfigValues.SPIDERSET) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.SPIDERSET) && player.isShiftKeyDown()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.SPIDERSET, false))) {
                        player.addEffect(SPIDER_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SPIDERSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.SPIDERSET, false))) {
                    player.removeEffect(MobEffects.JUMP);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SPIDERSET, false);
                }
            }
            if (KQConfigValues.NETHERSET) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.NETHERSET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.NETHERSET, false))) {
                        player.addEffect(NETHER_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.NETHERSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.NETHERSET, false))) {
                    player.removeEffect(MobEffects.FIRE_RESISTANCE);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.NETHERSET, false);
                }
            }
            if (KQConfigValues.SKULK) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.SKULK) && player.level().getMaxLocalRawBrightness(player.blockPosition()) <= 4) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.SKULK, false))) {
                        player.addEffect(SKULK_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SKULK, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.SKULK, false))) {
                    player.removeEffect(MobEffects.DAMAGE_RESISTANCE);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SKULK, false);
                }
            }
            if (KQConfigValues.STRAWHATSET) {
                if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.STRAWHATSET) && player.isUnderWater()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.STRAWHATSET, false))) {
                        player.addEffect(STRAWHAT_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.STRAWHATSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new HashMap()).getOrDefault(KQArmorMaterials.STRAWHATSET, false))) {
                    player.removeEffect(MobEffects.WATER_BREATHING);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.STRAWHATSET, false);
                }
            }
        }
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
    }

    private static boolean hasFullSetOn(Player player, Holder<ArmorMaterial> material) {
        ArmorItem leggingsArmor;
        ArmorItem chestplateArmor;
        ArmorItem helmetArmor;
        Item item;
        block5: {
            block4: {
                ItemStack boots = player.getInventory().getArmor(0);
                ItemStack leggings = player.getInventory().getArmor(1);
                ItemStack chestplate = player.getInventory().getArmor(2);
                ItemStack helmet = player.getInventory().getArmor(3);
                if (helmet.isEmpty() || chestplate.isEmpty() || leggings.isEmpty() || boots.isEmpty()) {
                    return false;
                }
                item = helmet.getItem();
                if (!(item instanceof ArmorItem)) break block4;
                helmetArmor = (ArmorItem)item;
                item = chestplate.getItem();
                if (!(item instanceof ArmorItem)) break block4;
                chestplateArmor = (ArmorItem)item;
                item = leggings.getItem();
                if (!(item instanceof ArmorItem)) break block4;
                leggingsArmor = (ArmorItem)item;
                item = boots.getItem();
                if (item instanceof ArmorItem) break block5;
            }
            return false;
        }
        ArmorItem bootsArmor = (ArmorItem)item;
        return helmetArmor.getMaterial() == material && chestplateArmor.getMaterial() == material && leggingsArmor.getMaterial() == material && bootsArmor.getMaterial() == material;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientSideDoubleJump(Player player) {
        boolean canDoubleJump;
        if (Minecraft.getInstance().options.keyJump.isDown() && (canDoubleJump = doubleJumpStates.getOrDefault(player.getUUID(), true).booleanValue())) {
            doubleJumpStates.put(player.getUUID(), false);
            for (int i = 0; i < 360; i += 60) {
                double angleRadians = Math.toRadians(i);
                double particleX = player.getX() + 0.4 * Math.cos(angleRadians);
                double particleZ = player.getZ() + 0.4 * Math.sin(angleRadians);
                player.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, particleX, player.getY(), particleZ, 0.0, 0.35, 0.0);
            }
            player.jumpFromGround();
        }
    }

    @Mod.EventBusSubscriber(modid="knightquest")
    public static class ArmorStatusManagerEvents {
        private static boolean isTeleportPositionValid(Level level, BlockPos pos) {
            return !level.getBlockState(pos.below()).isAir() && level.getBlockState(pos).isAir() && level.getBlockState(pos.above()).isAir();
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Object random;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                player = (Player)livingEntity;
                if (KQConfigValues.DEEPSLATESET && event.getSource().is(DamageTypes.FALL) && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.DEEPSLATESET)) {
                    float originalDamage = event.getAmount();
                    float reducedDamage = originalDamage * 0.2f;
                    event.setAmount(reducedDamage);
                }
                if (KQConfigValues.EVOKERSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.EVOKERSET)) {
                    Entity entity2;
                    random = new Random();
                    if (event.getSource().getEntity() != null && (entity2 = event.getSource().getEntity()) instanceof LivingEntity) {
                        LivingEntity entity3 = (LivingEntity)entity2;
                        if ((double)((Random)random).nextFloat() < 0.25) {
                            entity3.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 120, 0, false, false, true));
                        }
                    }
                }
                if (KQConfigValues.SQUIRESET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SQUIRESET)) {
                    event.setAmount(event.getAmount() * 0.85f);
                }
                if (KQConfigValues.BLAZESET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BLAZESET)) {
                    random = new Random();
                    if (event.getSource().getEntity() != null && (double)((Random)random).nextFloat() < 0.4) {
                        event.getSource().getEntity().setRemainingFireTicks(random.nextInt(2, 8) * 20);
                    }
                }
                if (KQConfigValues.DRAGONSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.DRAGONSET) && event.getSource().is(DamageTypes.DRAGON_BREATH)) {
                    event.setAmount(0.0f);
                }
                if (KQConfigValues.BAMBOOSET_GREEN && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET_GREEN) && player.hasEffect(MobEffects.POISON) && (event.getSource().is(DamageTypes.MAGIC) || event.getSource().is(DamageTypes.INDIRECT_MAGIC))) {
                    event.setAmount(0.0f);
                    player.removeEffect(MobEffects.POISON);
                }
                if (KQConfigValues.SHINOBI && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SHINOBI) && event.getSource().getEntity() != null) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 120, 1, false, false, true));
                }
                if (KQConfigValues.BAMBOOSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET) && event.getSource().is(DamageTypes.FALL)) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    int particleCount = 80;
                    double particleRadius = 1.2;
                    for (int i = 0; i < particleCount; ++i) {
                        double angleOffset = Math.PI * 2 / (double)particleCount * (double)i;
                        double xParticleOffset = particleRadius * Math.cos(angleOffset);
                        double zParticleOffset = particleRadius * Math.sin(angleOffset);
                        serverPlayer.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, true, player.getX() + xParticleOffset, player.getY() + 0.1, player.getZ() + zParticleOffset, 0.2f, 0.05f, 0.2f, 0.0f, 1));
                    }
                    player.level().getEntitiesOfClass(Monster.class, player.getBoundingBox().inflate(3.5)).forEach(entity -> {
                        Vec3 direction = entity.position().subtract(player.position()).normalize().scale((double)event.getAmount() * 0.5);
                        entity.push(direction.x, direction.y + 0.5, direction.z);
                    });
                }
                if (KQConfigValues.ENDERMANSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.ENDERMANSET) && event.getSource().getEntity() != null && (double)((Random)(random = new Random())).nextFloat() < 0.3) {
                    int radius = 5;
                    BlockPos playerPos = player.blockPosition();
                    ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
                    for (int x = -radius; x <= radius; ++x) {
                        for (int y = -radius; y <= radius; ++y) {
                            for (int z = -radius; z <= radius; ++z) {
                                BlockPos targetPos = new BlockPos(playerPos.getX() + x, playerPos.getY() + y, playerPos.getZ() + z);
                                if (!ArmorStatusManagerEvents.isTeleportPositionValid(player.level(), targetPos)) continue;
                                validPositions.add(targetPos);
                            }
                        }
                    }
                    if (!validPositions.isEmpty()) {
                        BlockPos randomPos = (BlockPos)validPositions.get(((Random)random).nextInt(validPositions.size()));
                        event.setAmount(0.0f);
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                        player.teleportTo((double)randomPos.getX(), (double)randomPos.getY(), (double)randomPos.getZ());
                    }
                }
                if (KQConfigValues.VETERANSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.VETERANSET) && (double)player.getHealth() < (double)player.getMaxHealth() * 0.5) {
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 200, 0, false, false, true));
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200, 1, false, false, true));
                }
                if (KQConfigValues.FORZESET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.FORZESET)) {
                    random = new Random();
                    if (event.getSource().getEntity() != null && (double)((Random)random).nextFloat() < 0.3) {
                        event.getSource().getEntity().hurt(event.getSource(), event.getAmount() * 0.5f);
                    }
                }
                if (KQConfigValues.CREEPERSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.CREEPERSET) && event.getSource().getEntity() != null && (event.getSource().is(DamageTypes.EXPLOSION) || event.getSource().is(DamageTypes.PLAYER_EXPLOSION))) {
                    event.setAmount(event.getAmount() * 0.1f);
                }
                if (KQConfigValues.POLAR && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.POLAR) && event.getSource().getEntity() != null && event.getSource().is(DamageTypes.FREEZE)) {
                    event.setAmount(0.0f);
                }
            }
            if ((random = event.getSource().getEntity()) instanceof Player) {
                player = (Player)random;
                if (event.getEntity() != null) {
                    if (KQConfigValues.SILVERSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SILVERSET) && player.level().isNight() && (double)((Random)(random = new Random())).nextFloat() < 0.3) {
                        event.getEntity().setRemainingFireTicks(random.nextInt(2, 8) * 20);
                    }
                    if (KQConfigValues.HOLLOWSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.HOLLOWSET)) {
                        player.heal(Math.min((float)((double)event.getAmount() * 0.25), event.getEntity().getHealth()));
                    }
                    if (KQConfigValues.DRAGONSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.DRAGONSET)) {
                        event.setAmount((float)((double)event.getAmount() * 1.15));
                    }
                    if (KQConfigValues.WITHERSET && event.getSource().is(DamageTypes.ARROW) && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WITHERSET)) {
                        random = new Random();
                        if (event.getSource().getEntity() != null && (double)((Random)random).nextFloat() < 0.3) {
                            event.getEntity().addEffect(new MobEffectInstance(MobEffects.WITHER, 120, 0, false, false, false));
                        }
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingUpdate(LivingEntityUseItemEvent.Finish event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (KQConfigValues.APPLE_SET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.APPLE_SET) && event.getItem().getItem().equals(Items.APPLE)) {
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 0, false, true, true));
                }
            }
        }

        @SubscribeEvent
        public static void onLivingDead(LivingDeathEvent event) {
            Entity entity;
            if (event.getEntity() != null && (entity = event.getSource().getEntity()) instanceof Player) {
                Player player = (Player)entity;
                if (KQConfigValues.CONQUISTADORSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.CONQUISTADORSET)) {
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 200, 1, false, true, true));
                }
                if (KQConfigValues.WITCH && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WITCH)) {
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 80, 0, false, true, true));
                }
            }
        }

        @SubscribeEvent
        public static void onLivingTick(LivingEvent.LivingTickEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                ItemStack helmet = player.getInventory().getArmor(3);
                if (KQConfigValues.TENGU_HELMET && helmet.getItem().equals(KnightQuestItems.TENGU_HELMET.get())) {
                    boolean canDoubleJump = doubleJumpStates.getOrDefault(player.getUUID(), true);
                    if (!player.onGround() && player.getDeltaMovement().y < 0.0 && canDoubleJump) {
                        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> KQArmorItem.handleClientSideDoubleJump(player));
                    }
                    if (player.onGround()) {
                        doubleJumpStates.put(player.getUUID(), true);
                    }
                }
                if (KQConfigValues.HUSKSET) {
                    if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.HUSKSET) && (player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.DESERT) || player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.BADLANDS) || player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.BEACH))) {
                        if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new HashMap()).getOrDefault(KQArmorMaterials.HUSKSET, false))) {
                            player.addEffect(HUSK_ARMOR);
                            effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.HUSKSET, true);
                        }
                    } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new HashMap()).getOrDefault(KQArmorMaterials.HUSKSET, false))) {
                        player.removeEffect(MobEffects.DAMAGE_RESISTANCE);
                        effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.HUSKSET, false);
                    }
                }
                if (KQConfigValues.BAMBOOSET_BLUE) {
                    if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET_BLUE) && (player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.JUNGLE) || player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.BAMBOO_JUNGLE) || player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.SPARSE_JUNGLE))) {
                        if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new HashMap()).getOrDefault(KQArmorMaterials.BAMBOOSET_BLUE, false))) {
                            player.addEffect(BAMBOO_BLUE);
                            effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.BAMBOOSET_BLUE, true);
                        }
                    } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new HashMap()).getOrDefault(KQArmorMaterials.BAMBOOSET_BLUE, false))) {
                        player.removeEffect(MobEffects.MOVEMENT_SPEED);
                        effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.BAMBOOSET_BLUE, false);
                    }
                }
                if (KQConfigValues.WARLORDSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WARLORDSET)) {
                    for (Entity entity : player.level().getEntitiesOfClass(Player.class, player.getBoundingBox().inflate(15.0))) {
                        if (!(entity instanceof Player)) continue;
                        Player nearbyPlayer = (Player)entity;
                        if (entity == player) continue;
                        nearbyPlayer.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 0, false, false, true));
                    }
                }
                if (KQConfigValues.ZOMBIESET && !player.level().isClientSide && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.ZOMBIESET) && player.level().isNight() && player.tickCount % 120 == 0) {
                    player.heal(1.0f);
                }
                if (KQConfigValues.POLAR && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.POLAR) && player.getTicksFrozen() > 0) {
                    player.setTicksFrozen(0);
                }
                if (KQConfigValues.SILVERFISHSET) {
                    if (KQArmorItem.hasFullSetOn(player, KQArmorMaterials.SILVERFISHSET) && player.getY() < 50.0) {
                        if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new HashMap()).getOrDefault(KQArmorMaterials.SILVERFISHSET, false))) {
                            player.addEffect(SILVERFISH_ARMOR);
                            effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.SILVERFISHSET, true);
                        }
                    } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new HashMap()).getOrDefault(KQArmorMaterials.SILVERFISHSET, false))) {
                        player.removeEffect(MobEffects.DIG_SPEED);
                        effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.SILVERFISHSET, false);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onArrowHit(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof AbstractArrow) {
                Player player;
                Entity entity2;
                AbstractArrow arrow = (AbstractArrow)entity;
                if (KQConfigValues.SKELETONSET && (entity2 = arrow.getOwner()) instanceof Player && KQFullSetChecker.hasFullSetOn(player = (Player)entity2, KQArmorMaterials.SKELETONSET)) {
                    arrow.setPierceLevel((byte)5);
                }
            }
        }
    }
}

