/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.common.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class PoisonParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected PoisonParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites) {
        super(pLevel, pX, pY, pZ);
        this.friction = 1.0f;
        this.sprites = pSprites;
        this.xd = pXSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.yd = pYSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.zd = pZSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        float minSize = 1.5f;
        float maxSize = 3.0f;
        this.quadSize = minSize + this.random.nextFloat() * (maxSize - minSize);
        this.lifetime = (int)(10.0 / ((double)this.random.nextFloat() * 0.5 + 0.2)) + 2;
        this.setSpriteFromAge(pSprites);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        this.xd *= (double)0.95f;
        this.yd *= (double)0.9f;
        this.zd *= (double)0.95f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            PoisonParticle snowflakeparticle = new PoisonParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, this.sprites);
            snowflakeparticle.setColor(0.923f, 0.964f, 0.999f);
            return snowflakeparticle;
        }
    }
}

