/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.xylonity.knightquest.datagen.KQAddItemModifier;
import net.xylonity.knightquest.registry.KnightQuestItems;
import org.jetbrains.annotations.NotNull;

public class KQGlobalLootModifiersProvider
extends GlobalLootModifierProvider {
    private static final ResourceLocation[] MOB_IDS;
    private static final ResourceLocation RATMAN_ID;
    private static final ResourceLocation LIZZY_ID;

    public KQGlobalLootModifiersProvider(PackOutput output, String modid, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, modid, registries);
    }

    protected void start(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        for (ResourceLocation mobId : MOB_IDS) {
            this.add(mobId.getPath() + "_small_essence", (IGlobalLootModifier)new KQAddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(mobId).build()}, new ItemStack((ItemLike)KnightQuestItems.SMALL_ESSENCE.get()).getItem(), 0.5f));
        }
        this.add(RATMAN_ID.getPath() + "_ratman_eye", (IGlobalLootModifier)new KQAddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(RATMAN_ID).build()}, new ItemStack((ItemLike)KnightQuestItems.RATMAN_EYE.get()).getItem(), 0.5f));
        this.add(LIZZY_ID.getPath() + "_lizzy_scale", (IGlobalLootModifier)new KQAddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(LIZZY_ID).build()}, new ItemStack((ItemLike)KnightQuestItems.LIZZY_SCALE.get()).getItem(), 0.5f));
    }

    static {
        int i;
        String[] vanilla = new String[]{"creeper", "spider", "skeleton", "zombie", "cave_spider", "blaze", "enderman", "ghast", "magma_cube", "phantom", "slime", "stray", "vex", "drowned", "witch", "husk", "zombie_villager", "wither_skeleton", "pillager", "vindicator", "evoker", "hoglin", "piglin"};
        String[] knightquest = new String[]{"gremlin", "eldknight", "samhain", "ratman", "swampman", "eldbomb", "lizzy", "bad_patch"};
        MOB_IDS = new ResourceLocation[vanilla.length + knightquest.length];
        for (i = 0; i < vanilla.length; ++i) {
            KQGlobalLootModifiersProvider.MOB_IDS[i] = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("entities/" + vanilla[i]));
        }
        for (i = 0; i < knightquest.length; ++i) {
            KQGlobalLootModifiersProvider.MOB_IDS[vanilla.length + i] = ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)("entities/" + knightquest[i]));
        }
        RATMAN_ID = ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"entities/ratman");
        LIZZY_ID = ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"entities/lizzy");
    }
}

