/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.registry;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.xylonity.knightquest.common.block.ChaliceBlock;
import net.xylonity.knightquest.registry.KnightQuestItems;
import org.jetbrains.annotations.NotNull;

public class KnightQuestBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"knightquest");
    public static final RegistryObject<Block> GREAT_CHALICE = KnightQuestBlocks.registerBlock("great_chalice", () -> new ChaliceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundType.COPPER).lightLevel(state -> switch ((Integer)state.getValue((Property)ChaliceBlock.fill)) {
        case 1 -> 1;
        case 2, 9 -> 2;
        case 3, 8 -> 4;
        case 4, 7 -> 6;
        case 5, 6 -> 8;
        default -> 0;
    })){

        public void appendHoverText(@NotNull ItemStack pStack, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.item.knightquest.great_chalice"));
            super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        }
    });

    private static <X extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<X> block) {
        return KnightQuestItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <X extends Block> RegistryObject<X> registerBlock(String name, Supplier<X> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        KnightQuestBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }
}

