/*
 * Decompiled with CFR 0.152.
 */
package net.xylonity.knightquest.registry;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.xylonity.knightquest.common.entity.boss.NethermanCloneEntity;
import net.xylonity.knightquest.common.entity.boss.NethermanEntity;
import net.xylonity.knightquest.common.entity.boss.NethermanTeleportChargeEntity;
import net.xylonity.knightquest.common.entity.entities.BadPatchEntity;
import net.xylonity.knightquest.common.entity.entities.EldBombEntity;
import net.xylonity.knightquest.common.entity.entities.EldKnightEntity;
import net.xylonity.knightquest.common.entity.entities.GhastlingEntity;
import net.xylonity.knightquest.common.entity.entities.GhostyEntity;
import net.xylonity.knightquest.common.entity.entities.GremlinEntity;
import net.xylonity.knightquest.common.entity.entities.LizzyEntity;
import net.xylonity.knightquest.common.entity.entities.MommaLizzyEntity;
import net.xylonity.knightquest.common.entity.entities.RatmanEntity;
import net.xylonity.knightquest.common.entity.entities.SamhainEntity;
import net.xylonity.knightquest.common.entity.entities.SwampmanAxeEntity;
import net.xylonity.knightquest.common.entity.entities.SwampmanEntity;

public class KnightQuestEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"knightquest");
    public static final RegistryObject<EntityType<GremlinEntity>> GREMLIN = KnightQuestEntities.register("gremlin", GremlinEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<EldBombEntity>> ELDBOMB = KnightQuestEntities.register("eldbomb", EldBombEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<EldKnightEntity>> ELDKINGHT = KnightQuestEntities.register("eldknight", EldKnightEntity::new, MobCategory.MONSTER, 1.0f, 2.6f);
    public static final RegistryObject<EntityType<SwampmanEntity>> SWAMPMAN;
    public static final RegistryObject<EntityType<SamhainEntity>> SAMHAIN;
    public static final RegistryObject<EntityType<RatmanEntity>> RATMAN;
    public static final RegistryObject<EntityType<LizzyEntity>> LIZZY;
    public static final RegistryObject<EntityType<BadPatchEntity>> BADPATCH;
    public static final RegistryObject<EntityType<GhastlingEntity>> SHIELD;
    public static final RegistryObject<EntityType<MommaLizzyEntity>> MOMMA_LIZZY;
    public static final RegistryObject<EntityType<GhostyEntity>> GHOSTY;
    public static final RegistryObject<EntityType<NethermanEntity>> NETHERMAN;
    public static final RegistryObject<EntityType<NethermanCloneEntity>> NETHERMAN_CLONE;
    public static final RegistryObject<EntityType<NethermanTeleportChargeEntity>> NETHERMAN_TELEPORT_CHARGE;
    public static final RegistryObject<EntityType<SwampmanAxeEntity>> SWAMPMAN_AXE;

    private static <X extends Entity> RegistryObject<EntityType<X>> register(String name, EntityType.EntityFactory<X> entity, MobCategory category, float width, float height) {
        return ENTITY.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)entity, (MobCategory)category).sized(width, height).build(String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)name))));
    }

    static {
        SAMHAIN = KnightQuestEntities.register("samhain", SamhainEntity::new, MobCategory.MONSTER, 1.0f, 1.5f);
        SWAMPMAN = KnightQuestEntities.register("swampman", SwampmanEntity::new, MobCategory.MONSTER, 1.0f, 2.0f);
        RATMAN = KnightQuestEntities.register("ratman", RatmanEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
        LIZZY = KnightQuestEntities.register("lizzy", LizzyEntity::new, MobCategory.AMBIENT, 1.0f, 0.3f);
        BADPATCH = KnightQuestEntities.register("bad_patch", BadPatchEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
        SHIELD = KnightQuestEntities.register("ghastling", GhastlingEntity::new, MobCategory.MONSTER, 0.65f, 0.65f);
        MOMMA_LIZZY = KnightQuestEntities.register("momma_lizzy", MommaLizzyEntity::new, MobCategory.MONSTER, 1.0f, 0.3f);
        GHOSTY = KnightQuestEntities.register("ghosty", GhostyEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
        NETHERMAN = KnightQuestEntities.register("netherman", NethermanEntity::new, MobCategory.MONSTER, 0.8f, 2.8f);
        NETHERMAN_CLONE = KnightQuestEntities.register("netherman_clone", NethermanCloneEntity::new, MobCategory.MONSTER, 0.8f, 2.8f);
        NETHERMAN_TELEPORT_CHARGE = KnightQuestEntities.register("netherman_teleport_charge", NethermanTeleportChargeEntity::new, MobCategory.MONSTER, 0.5f, 0.5f);
        SWAMPMAN_AXE = KnightQuestEntities.register("swampman_axe", SwampmanAxeEntity::new, MobCategory.MONSTER, 0.3f, 1.0f);
    }
}

