/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration;

import dev.toma.configuration.client.screen.ConfigGroupScreen;
import dev.toma.configuration.client.screen.ConfigScreen;
import dev.toma.configuration.config.Config;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import dev.toma.configuration.config.io.ConfigIO;
import dev.toma.configuration.config.value.ConfigValue;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public final class Configuration
implements ModInitializer {
    public static final String MODID = "configuration";
    public static final Logger LOGGER = LogManager.getLogger((String)"Configuration");
    public static final Marker MAIN_MARKER = MarkerManager.getMarker((String)"main");

    public void onInitialize() {
        ConfigIO.FILE_WATCH_MANAGER.startService();
    }

    public static <CFG> ConfigHolder<CFG> registerConfig(Class<CFG> cfgClass, IConfigFormatHandler formatFactory) {
        String group;
        Config cfg = cfgClass.getAnnotation(Config.class);
        if (cfg == null) {
            throw new IllegalArgumentException("Config class must be annotated with '@Config' annotation");
        }
        String id = cfg.id();
        String filename = cfg.filename();
        if (filename.isEmpty()) {
            filename = id;
        }
        if ((group = cfg.group()).isEmpty()) {
            group = id;
        }
        ConfigHolder<CFG> holder = new ConfigHolder<CFG>(cfgClass, id, filename, group, formatFactory);
        ConfigHolder.registerConfig(holder);
        if (cfgClass.getAnnotation(Config.NoAutoSync.class) == null) {
            ConfigIO.FILE_WATCH_MANAGER.addTrackedConfig(holder);
        }
        return holder;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public static class_437 getConfigScreen(Class<?> configClass, class_437 previous) {
        Config cfg = configClass.getAnnotation(Config.class);
        if (cfg == null) {
            return null;
        }
        String id = cfg.id();
        return Configuration.getConfigScreen(id, previous);
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public static class_437 getConfigScreen(String configId, class_437 previous) {
        return ConfigHolder.getConfig(configId).map(holder -> Configuration.getConfigScreenForHolder(holder, previous)).orElse(null);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_437 getConfigScreenByGroup(String group, class_437 previous) {
        List<ConfigHolder<?>> list = ConfigHolder.getConfigsByGroup(group);
        if (list.isEmpty()) {
            return null;
        }
        return Configuration.getConfigScreenByGroup(list, group, previous);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_437 getConfigScreenForHolder(ConfigHolder<?> holder, class_437 previous) {
        Map<String, ConfigValue<?>> valueMap = holder.getValueMap();
        return new ConfigScreen(holder.getConfigId(), holder.getConfigId(), valueMap, previous);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_437 getConfigScreenByGroup(List<ConfigHolder<?>> group, String groupId, class_437 previous) {
        return new ConfigGroupScreen(previous, groupId, group);
    }
}

