/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.adapter;

import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.adapter.TypeMatcher;
import dev.toma.configuration.config.value.BooleanArrayValue;
import dev.toma.configuration.config.value.BooleanValue;
import dev.toma.configuration.config.value.CharValue;
import dev.toma.configuration.config.value.DoubleArrayValue;
import dev.toma.configuration.config.value.DoubleValue;
import dev.toma.configuration.config.value.EnumValue;
import dev.toma.configuration.config.value.FloatArrayValue;
import dev.toma.configuration.config.value.FloatValue;
import dev.toma.configuration.config.value.IntArrayValue;
import dev.toma.configuration.config.value.IntValue;
import dev.toma.configuration.config.value.LongArrayValue;
import dev.toma.configuration.config.value.LongValue;
import dev.toma.configuration.config.value.ObjectValue;
import dev.toma.configuration.config.value.StringArrayValue;
import dev.toma.configuration.config.value.StringValue;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class TypeAdapters {
    private static final Map<TypeMatcher, TypeAdapter> ADAPTER_MAP = new HashMap<TypeMatcher, TypeAdapter>();

    public static TypeAdapter forType(Class<?> type) {
        return ADAPTER_MAP.entrySet().stream().filter(entry -> ((TypeMatcher)entry.getKey()).test(type)).sorted(Comparator.comparingInt(value -> ((TypeMatcher)value.getKey()).priority())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public static void registerTypeAdapter(TypeMatcher matcher, TypeAdapter adapter) {
        if (ADAPTER_MAP.put(matcher, adapter) != null) {
            throw new IllegalArgumentException("Duplicate type matcher with id: " + matcher.getIdentifier());
        }
    }

    static {
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchBoolean(), new BooleanValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchCharacter(), new CharValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchInteger(), new IntValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchLong(), new LongValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchFloat(), new FloatValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchDouble(), new DoubleValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchString(), new StringValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchBooleanArray(), new BooleanArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchIntegerArray(), new IntArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchLongArray(), new LongArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchFloatArray(), new FloatArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchDoubleArray(), new DoubleArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchStringArray(), new StringArrayValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchEnum(), new EnumValue.Adapter());
        TypeAdapters.registerTypeAdapter(TypeMatcher.matchObject(), new ObjectValue.Adapter());
    }
}

