/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screenhandler.v1.ScreenRegistry;
import net.minecraft.class_1937;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.tnt.collectoralbum.CollectorsAlbum;
import team.tnt.collectoralbum.api.IAlbumScreenFactory;
import team.tnt.collectoralbum.client.screen.AlbumScreen;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.init.MenuTypes;
import team.tnt.collectoralbum.common.menu.AlbumMenu;
import team.tnt.collectoralbum.data.boosts.OpType;
import team.tnt.collectoralbum.network.Networking;

public class CollectorsAlbumClient
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger(CollectorsAlbumClient.class);
    private int timer;
    private static int albumPageIndex;
    private static int pageCount;

    public void onInitializeClient() {
        Networking.registerClientReceivers();
        ScreenRegistry.register(MenuTypes.ALBUM, (menu, inventory, title) -> {
            ICardCategory category = menu.getCategory();
            if (category == null) {
                return new AlbumScreen((AlbumMenu)menu, inventory, title);
            }
            IAlbumScreenFactory factory = category.getAlbumScreenFactory();
            return factory.createAlbumScreen((AlbumMenu)menu, inventory, title);
        });
        ClientTickEvents.START_WORLD_TICK.register(this::handleClientTick);
    }

    public void handleClientTick(class_1937 level) {
        ++this.timer;
        CollectorsAlbum.ALBUM_CARD_BOOST_MANAGER.getBoosts().ifPresent(collection -> {
            pageCount = collection.getActionsCount(OpType.ACTIVE);
            if (pageCount > 0) {
                albumPageIndex = this.timer / 60 % pageCount;
            }
        });
    }

    public static int getPageCount() {
        return pageCount;
    }

    public static int getAlbumPageIndex() {
        return albumPageIndex;
    }
}

