/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import team.tnt.collectoralbum.common.AlbumStats;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.init.CardCategoryRegistry;
import team.tnt.collectoralbum.common.item.CardRarity;
import team.tnt.collectoralbum.common.item.ICard;
import team.tnt.collectoralbum.common.menu.AlbumMenu;
import team.tnt.collectoralbum.network.Networking;
import team.tnt.collectoralbum.network.packet.RequestAlbumPagePacket;

public class AlbumScreen
extends class_465<AlbumMenu> {
    private static final class_2960 TITLE = new class_2960("collectorsalbum", "textures/screen/album_title.png");
    private static final class_2960 BACKGROUND = new class_2960("collectorsalbum", "textures/screen/album.png");
    private static final class_2960 ARROW_LEFT = new class_2960("collectorsalbum", "textures/screen/album_previous.png");
    private static final class_2960 ARROW_RIGHT = new class_2960("collectorsalbum", "textures/screen/album_next.png");
    private static final class_5250 TEXT_HEADER = class_2561.method_43471((String)"text.collectorsalbum.album.header").method_27692(class_124.field_1067);
    private static final class_5250 TEXT_CATEGORIES = class_2561.method_43471((String)"text.collectorsalbum.album.categories").method_27692(class_124.field_1073);
    private static final class_5250 TEXT_RARITIES = class_2561.method_43471((String)"text.collectorsalbum.album.rarities").method_27692(class_124.field_1073);
    private static final Function<Integer, class_5250> TEXT_POINTS = points -> class_2561.method_43469((String)"text.collectorsalbum.album.points", (Object[])new Object[]{points});
    private static final BiFunction<Integer, Integer, class_5250> TEXT_TOTAL_CARDS = (cards, total) -> class_2561.method_43469((String)"text.collectorsalbum.album.total_cards", (Object[])new Object[]{cards, total});
    private final int pageIndex;
    private AlbumStats stats;

    public AlbumScreen(AlbumMenu abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)abstractContainerMenu, inventory, component);
        this.field_2792 = 306;
        this.field_2779 = 257;
        this.pageIndex = ((AlbumMenu)this.field_2797).isTitle() ? 0 : ((AlbumMenu)this.field_2797).getCategoryIndex();
    }

    protected void method_25426() {
        ArrowWidget widget;
        super.method_25426();
        if (this.pageIndex > 0) {
            widget = (ArrowWidget)this.method_37063((class_364)new ArrowWidget(this.field_2776 + 18, this.field_2800 + 5, 16, 16, ARROW_LEFT));
            widget.setOnClickResponder(this::clickPrevPage);
        }
        if (this.pageIndex < CardCategoryRegistry.getCount()) {
            widget = (ArrowWidget)this.method_37063((class_364)new ArrowWidget(this.field_2776 + 265, this.field_2800 + 4, 16, 16, ARROW_RIGHT));
            widget.setOnClickResponder(this::clickNextPage);
        }
        this.stats = ((AlbumMenu)this.field_2797).getContainer().getStats();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 68 || keyCode == 262) {
            this.changePage(1);
            return true;
        }
        if (keyCode == 65 || keyCode == 263) {
            this.changePage(-1);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_2389(class_4587 poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)(((AlbumMenu)this.field_2797).isTitle() ? TITLE : BACKGROUND));
        class_1159 pose = poseStack.method_23760().method_23761();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(pose, (float)this.field_2776, (float)this.field_2800, 0.0f).method_22913(0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(pose, (float)this.field_2776, (float)(this.field_2800 + this.field_2779), 0.0f).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(pose, (float)(this.field_2776 + this.field_2792), (float)(this.field_2800 + this.field_2779), 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(pose, (float)(this.field_2776 + this.field_2792), (float)this.field_2800, 0.0f).method_22913(1.0f, 0.0f).method_1344();
        tesselator.method_1350();
    }

    protected void method_2388(class_4587 poseStack, int mouseX, int mouseY) {
        if (((AlbumMenu)this.field_2797).isTitle()) {
            int headerWidth = this.field_22793.method_27525((class_5348)TEXT_HEADER);
            this.field_22793.method_30883(poseStack, (class_2561)TEXT_HEADER, 20.0f + (float)(130 - headerWidth) / 2.0f, 13.0f, 8150349);
            this.field_22793.method_30883(poseStack, (class_2561)TEXT_RARITIES, 27.0f, 55.0f, 8150349);
            int i = 0;
            Map<CardRarity, Integer> byRarity = this.stats.getCardsByRarity();
            for (CardRarity rarity : CardRarity.values()) {
                int value = byRarity.getOrDefault((Object)rarity, 0);
                String name = rarity.name();
                String pct = Math.round((float)value / (float)this.stats.getCardsCollected() * 100.0f) + "%";
                String text = name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase() + ": " + pct;
                this.field_22793.method_1729(poseStack, text, 30.0f, (float)(67 + i++ * 10), 8150349);
            }
            int collected = this.stats.getCardsCollected();
            int total = this.stats.getTotalCards();
            this.field_22793.method_30883(poseStack, (class_2561)TEXT_TOTAL_CARDS.apply(collected, total), 27.0f, 35.0f, 8150349);
            int points = this.stats.getPoints();
            this.field_22793.method_30883(poseStack, (class_2561)TEXT_POINTS.apply(points), 27.0f, (float)(80 + i * 10), 8150349);
            this.field_22793.method_30883(poseStack, (class_2561)TEXT_CATEGORIES, 164.0f, 35.0f, 8150349);
            int j = 0;
            Map<ICardCategory, List<ICard>> map = this.stats.getCardsByCategory();
            for (ICardCategory category : (ICardCategory[])CardCategoryRegistry.getValues().stream().sorted().toArray(ICardCategory[]::new)) {
                int value = Optional.ofNullable(map.get(category)).map(List::size).orElse(0);
                class_2561 displayName = category.getTranslatedName();
                String count = value + " / " + category.getCapacity();
                String text = displayName.getString() + " - " + count;
                this.field_22793.method_1729(poseStack, text, 167.0f, (float)(47 + j++ * 10), 8150349);
            }
            return;
        }
        for (class_1735 slot : ((AlbumMenu)this.field_2797).field_7761) {
            if (!(slot instanceof AlbumMenu.CardSlot)) continue;
            AlbumMenu.CardSlot cardSlot = (AlbumMenu.CardSlot)slot;
            int cardNumber = cardSlot.getCardNumber();
            String text = "#" + cardNumber;
            this.field_22793.method_1729(poseStack, text, (float)slot.field_7873 + (float)(18 - this.field_22793.method_1727(text)) / 2.0f - 1.0f, (float)(slot.field_7872 + 18), 8150349);
        }
        ICardCategory category = ((AlbumMenu)this.field_2797).getCategory();
        class_5250 component = class_2561.method_43470((String)category.getTranslatedName().getString()).method_27692(class_124.field_1056);
        this.field_22793.method_30883(poseStack, (class_2561)component, 40.0f, 10.0f, 8150349);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        this.method_2380(poseStack, mouseX, mouseY);
    }

    protected void clickPrevPage(ArrowWidget widget) {
        this.changePage(-1);
    }

    protected void clickNextPage(ArrowWidget widget) {
        this.changePage(1);
    }

    protected void changePage(int indexOffset) {
        int nextIndex = this.pageIndex + indexOffset;
        if (nextIndex < 0 || nextIndex > CardCategoryRegistry.getCount()) {
            return;
        }
        ICardCategory category = nextIndex == 0 ? null : CardCategoryRegistry.byIndex(nextIndex - 1);
        Networking.dispatchServerPacket(new RequestAlbumPagePacket(category));
    }

    protected static final class ArrowWidget
    extends class_339 {
        private final class_2960 location;
        private ClickResponder clickResponder = widget -> {};

        public ArrowWidget(int x, int y, int width, int height, class_2960 location) {
            super(x, y, width, height, class_5244.field_39003);
            this.location = location;
        }

        public void setOnClickResponder(ClickResponder responder) {
            this.clickResponder = responder;
        }

        public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.location);
            class_1159 pose = poseStack.method_23760().method_23761();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(pose, (float)this.field_22760, (float)this.field_22761, 0.0f).method_22913(0.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(pose, (float)this.field_22760, (float)(this.field_22761 + this.field_22758), 0.0f).method_22913(0.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(pose, (float)(this.field_22760 + this.field_22759), (float)(this.field_22761 + this.field_22758), 0.0f).method_22913(1.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(pose, (float)(this.field_22760 + this.field_22759), (float)this.field_22761, 0.0f).method_22913(1.0f, 0.0f).method_1344();
            tesselator.method_1350();
        }

        public void method_25348(double mouseX, double mouseY) {
            this.clickResponder.onClick(this);
        }

        public void method_37020(class_6382 narrationElementOutput) {
        }

        @FunctionalInterface
        static interface ClickResponder {
            public void onClick(ArrowWidget var1);
        }
    }
}

