/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1159;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import team.tnt.collectoralbum.CollectorsAlbum;
import team.tnt.collectoralbum.client.screen.ITickableWidget;
import team.tnt.collectoralbum.common.item.ICard;
import team.tnt.collectoralbum.network.Networking;
import team.tnt.collectoralbum.network.packet.RequestCardPackDropPacket;

public class CardOpenScreen
extends class_437 {
    private static final class_2960 CARD_BACK = new class_2960("collectorsalbum", "textures/screen/card_back.png");
    private final List<ITickableWidget> tickableWidgets = new ArrayList<ITickableWidget>();
    private final List<class_1799> drops;
    private int flipsRemaining;

    public CardOpenScreen(List<class_1799> drops) {
        super((class_2561)class_2561.method_43470((String)"Card Open Screen"));
        this.drops = drops;
        Collections.shuffle(this.drops);
    }

    protected void method_25426() {
        int total;
        this.tickableWidgets.clear();
        this.flipsRemaining = total = this.drops.size();
        int deckWidth = (total - 1) * 65 + 64;
        int left = (this.field_22789 - deckWidth) / 2;
        int top = (this.field_22790 - 64) / 2;
        for (int i = 0; i < total; ++i) {
            int desiredX = left + i * 65;
            CardWidget widget = this.method_37063(new CardWidget(this.field_22789 - 70 + i * 7, this.field_22790 - 70, 64, 64, desiredX, top, this.drops.get(i)));
            widget.setAnimTime(15);
            widget.setFlipTime(15);
            widget.setClickResponder(this::cardFlipped);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.flipsRemaining == 0) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        super.method_25419();
        if (!CollectorsAlbum.config.requireTurnAllCards || this.flipsRemaining == 0) {
            Networking.dispatchServerPacket(new RequestCardPackDropPacket());
        }
    }

    public void method_25393() {
        this.tickableWidgets.forEach(ITickableWidget::tickWidget);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean method_25421() {
        return false;
    }

    protected <T extends class_364 & class_4068> T method_37063(T widget) {
        if (widget instanceof ITickableWidget) {
            ITickableWidget tickable = (ITickableWidget)widget;
            this.tickableWidgets.add(tickable);
        }
        return (T)super.method_37063(widget);
    }

    private void cardFlipped(CardWidget widget) {
        --this.flipsRemaining;
    }

    public static void renderTexture(class_1159 pose, float x1, float y1, float x2, float y2) {
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(pose, x1, y1, 0.0f).method_22913(0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(pose, x1, y2, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(pose, x2, y2, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(pose, x2, y1, 0.0f).method_22913(1.0f, 0.0f).method_1344();
        tesselator.method_1350();
        RenderSystem.disableBlend();
    }

    private static final class CardWidget
    extends class_339
    implements ITickableWidget {
        private final int targetX;
        private final int targetY;
        private final int startX;
        private final int startY;
        private final class_2960 itemTexture;
        private final class_3414 discoverySound;
        private int animTime = 30;
        private int timer;
        private int prevTimer;
        private Consumer<CardWidget> widgetConsumer = widget -> {};
        private boolean flipped;
        private boolean flipping;
        private int flipTimer;
        private int flipTimerOld;
        private int flipTimeTotal = 20;

        public CardWidget(int x, int y, int width, int height, int targetX, int targetY, class_1799 stack) {
            super(x, y, width, height, class_5244.field_39003);
            this.startX = x;
            this.startY = y;
            this.targetX = targetX;
            this.targetY = targetY;
            class_2960 itemId = class_2378.field_11142.method_10221((Object)stack.method_7909());
            this.itemTexture = new class_2960(itemId.method_12836(), "textures/item/" + itemId.method_12832() + ".png");
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof ICard) {
                ICard card = (ICard)class_17922;
                this.discoverySound = card.getCardRarity().getDiscoverySound();
            } else {
                this.discoverySound = null;
            }
        }

        public void setAnimTime(int time) {
            this.animTime = time;
        }

        public void setFlipTime(int time) {
            this.flipTimeTotal = time;
        }

        public void setClickResponder(Consumer<CardWidget> widgetConsumer) {
            this.widgetConsumer = widgetConsumer;
        }

        public void method_25348(double mouseX, double mouseY) {
            this.widgetConsumer.accept(this);
            this.flipping = true;
            if (this.discoverySound != null) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)this.discoverySound, (float)1.0f));
            }
        }

        public void method_25354(class_1144 handler) {
        }

        protected boolean method_25361(double mouseX, double mouseY) {
            return !this.flipped && !this.flipping && super.method_25361(mouseX, mouseY);
        }

        @Override
        public void tickWidget() {
            this.updateMovementAnimationTimer();
            this.doFlipProcessTick();
        }

        public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            int scale = this.field_22762 ? 8 : 0;
            float actual = (float)this.timer / (float)this.animTime;
            float old = (float)this.prevTimer / (float)this.animTime;
            float rawProgress = class_3532.method_16439((float)partialTick, (float)old, (float)actual);
            float progress = 1.0f - (float)Math.pow(1.0f - rawProgress, 3.0);
            int diffX = this.targetX - this.startX;
            int diffY = this.targetY - this.startY;
            float renderX = (float)this.startX + (float)diffX * progress;
            float renderY = (float)this.startY + (float)diffY * progress;
            this.field_22760 = (int)renderX;
            this.field_22761 = (int)renderY;
            class_308.method_24210();
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)(this.flipped ? this.itemTexture : CARD_BACK));
            this.actuallyRender(poseStack, renderX - (float)scale, renderY - (float)scale, renderX + (float)this.field_22758 + (float)scale, renderY + (float)this.field_22759 + (float)scale, partialTick);
        }

        private void actuallyRender(class_4587 stack, float x1, float y1, float x2, float y2, float partialTicks) {
            if (this.flipping) {
                float flipProgress;
                float flipOld = (float)this.flipTimerOld / (float)this.flipTimeTotal;
                float flipActual = (float)this.flipTimer / (float)this.flipTimeTotal;
                float flipProgressRaw = class_3532.method_16439((float)partialTicks, (float)flipOld, (float)flipActual);
                float f = flipProgress = (double)flipProgressRaw < 0.5 ? 4.0f * flipProgressRaw * flipProgressRaw * flipProgressRaw : 1.0f - (float)Math.pow(-2.0f * flipProgressRaw + 2.0f, 3.0) / 2.0f;
                if ((double)flipProgress >= 0.5) {
                    this.flipped = true;
                }
                float halfX = (x2 - x1) / 2.0f;
                float centerX = x1 + halfX;
                float progress = (double)flipProgress < 0.5 ? 1.0f - flipProgress / 0.5f : (flipProgress - 0.5f) / 0.5f;
                x1 = centerX - halfX * progress;
                x2 = centerX + halfX * progress;
            }
            class_1159 pose = stack.method_23760().method_23761();
            CardOpenScreen.renderTexture(pose, x1, y1, x2, y2);
        }

        public void method_37020(class_6382 narrationElementOutput) {
        }

        private void updateMovementAnimationTimer() {
            this.prevTimer = this.timer;
            if (this.timer >= this.animTime) {
                return;
            }
            ++this.timer;
        }

        private void doFlipProcessTick() {
            if (!this.flipping) {
                return;
            }
            this.flipTimerOld = this.flipTimer;
            if (this.flipTimer >= this.flipTimeTotal) {
                return;
            }
            ++this.flipTimer;
        }
    }
}

