/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1277;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.container.AlbumContainer;
import team.tnt.collectoralbum.common.init.CardCategoryRegistry;
import team.tnt.collectoralbum.common.init.CardRegistry;
import team.tnt.collectoralbum.common.item.CardRarity;
import team.tnt.collectoralbum.common.item.ICard;

public class AlbumStats {
    private final int cardsCollected;
    private final int totalCards;
    private final Map<CardRarity, Integer> cardsByRarity = new EnumMap<CardRarity, Integer>(CardRarity.class);
    private final Map<ICardCategory, List<ICard>> cardsByCategory;
    private final int points;

    public AlbumStats(AlbumContainer container) {
        this.cardsByCategory = new HashMap<ICardCategory, List<ICard>>();
        int collected = 0;
        int pointCounter = 0;
        for (ICardCategory category : CardCategoryRegistry.getValues()) {
            class_1277 categoryContainer = container.forCategory(category);
            for (int i = 0; i < categoryContainer.method_5439(); ++i) {
                class_1799 stack = categoryContainer.method_5438(i);
                class_1792 class_17922 = stack.method_7909();
                if (!(class_17922 instanceof ICard)) continue;
                ICard card = (ICard)class_17922;
                ++collected;
                this.cardsByCategory.computeIfAbsent(category, k -> new ArrayList()).add(card);
                CardRarity rarity = card.getCardRarity();
                this.increaseCounter(this.cardsByRarity, rarity);
                pointCounter += rarity.getValue();
            }
        }
        this.cardsCollected = collected;
        this.totalCards = CardRegistry.count();
        this.points = pointCounter;
    }

    private AlbumStats(int cards, int points, Map<ICardCategory, List<ICard>> byCategory) {
        this.cardsCollected = cards;
        this.totalCards = CardRegistry.count();
        this.points = points;
        this.cardsByCategory = byCategory;
    }

    public static AlbumStats createSimplifiedWithoutContainer(class_1799 album) {
        class_2487 tag = album.method_7948();
        class_2487 inventories = tag.method_10562("inventories");
        int cardCounter = 0;
        int pointCounter = 0;
        HashMap<ICardCategory, List<ICard>> byCategory = new HashMap<ICardCategory, List<ICard>>();
        for (ICardCategory category : CardCategoryRegistry.getValues()) {
            class_2499 slots = inventories.method_10554(category.getId().toString(), 10);
            for (int i = 0; i < slots.size(); ++i) {
                class_2487 slotDef = slots.method_10602(i);
                class_1799 item = class_1799.method_7915((class_2487)slotDef.method_10562("itemStack"));
                class_1792 class_17922 = item.method_7909();
                if (!(class_17922 instanceof ICard)) continue;
                ICard card = (ICard)class_17922;
                ++cardCounter;
                pointCounter += card.getCardRarity().getValue();
                byCategory.computeIfAbsent(category, k -> new ArrayList()).add(card);
            }
        }
        return new AlbumStats(cardCounter, pointCounter, byCategory);
    }

    public int getCardsCollected() {
        return this.cardsCollected;
    }

    public int getTotalCards() {
        return this.totalCards;
    }

    public Map<CardRarity, Integer> getCardsByRarity() {
        return this.cardsByRarity;
    }

    public Map<ICardCategory, List<ICard>> getCardsByCategory() {
        return this.cardsByCategory;
    }

    public int getPoints() {
        return this.points;
    }

    private <K> void increaseCounter(Map<K, Integer> map, K key) {
        int value = map.computeIfAbsent(key, k -> 0) + 1;
        map.put(key, value);
    }
}

