/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.class_2960;
import team.tnt.collectoralbum.common.CardCategoryIndexPool;
import team.tnt.collectoralbum.common.ICardCategory;

public record CardDefinition(class_2960 cardId, ICardCategory category, int cardNumber) {
    private static final Int2ObjectMap<CardDefinition> CARD_BY_ID = new Int2ObjectOpenHashMap();

    public CardDefinition(class_2960 cardId, ICardCategory category, int cardNumber) {
        if (cardNumber > category.getCapacity()) {
            throw new IndexOutOfBoundsException("Category card index overflow! Got " + cardNumber + ", capacity: " + category.getCapacity() + " for card " + cardId);
        }
        int idValue = CardCategoryIndexPool.getIndexOffset(category) + cardNumber;
        if (CARD_BY_ID.put(idValue, (Object)this) != null) {
            throw new IllegalStateException("Duplicate card number " + cardNumber);
        }
        this.cardId = cardId;
        this.category = category;
        this.cardNumber = cardNumber;
    }

    public static CardDefinition getCardByNumericId(int id) {
        return (CardDefinition)CARD_BY_ID.get(id);
    }
}

