/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common.init;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import team.tnt.collectoralbum.data.boosts.ActionType;
import team.tnt.collectoralbum.data.boosts.ClearEffectsAction;
import team.tnt.collectoralbum.data.boosts.FirstValidAction;
import team.tnt.collectoralbum.data.boosts.GiveEffectsAction;
import team.tnt.collectoralbum.data.boosts.GiveMissingEffectAction;
import team.tnt.collectoralbum.data.boosts.IAction;
import team.tnt.collectoralbum.data.boosts.IActionSerializer;
import team.tnt.collectoralbum.data.boosts.OpType;

public final class ActionTypeRegistry {
    private static final Map<class_2960, ActionType<?>> REGISTRY = new HashMap();
    public static final ActionType<ClearEffectsAction> CLEAR_EFFECTS = ActionTypeRegistry.internalRegister("clear_effects", OpType.any(), new ClearEffectsAction.Serializer());
    public static final ActionType<GiveEffectsAction> GIVE_EFFECTS = ActionTypeRegistry.internalRegister("give_effects", OpType.specific(OpType.ACTIVE), new GiveEffectsAction.Serializer());
    public static final ActionType<GiveMissingEffectAction> GIVE_MISSING_EFFECTS = ActionTypeRegistry.internalRegister("give_missing_effects", OpType.specific(OpType.ACTIVE), new GiveMissingEffectAction.Serializer());
    public static final ActionType<FirstValidAction> FIRST_VALID = ActionTypeRegistry.internalRegister("first_valid", OpType.any(), new FirstValidAction.Serializer());

    public static void register(ActionType<?> type) {
        REGISTRY.put(type.getId(), type);
    }

    public static <A extends IAction> ActionType<A> get(class_2960 id) {
        return REGISTRY.get(id);
    }

    private static <A extends IAction> ActionType<A> internalRegister(String id, Predicate<OpType> filter, IActionSerializer<A> serializer) {
        ActionType<A> type = new ActionType<A>(new class_2960("collectorsalbum", id), filter, serializer);
        ActionTypeRegistry.register(type);
        return type;
    }
}

