/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common.init;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import team.tnt.collectoralbum.common.CardCategory;
import team.tnt.collectoralbum.common.ICardCategory;

public class CardCategoryRegistry {
    private static final Map<class_2960, ICardCategory> REGISTRY = new HashMap<class_2960, ICardCategory>();
    public static final ICardCategory TOOLS = CardCategoryRegistry.internalRegister("tools", class_124.field_1054);
    public static final ICardCategory ARMOR = CardCategoryRegistry.internalRegister("armor", class_124.field_1078);
    public static final ICardCategory MOBS = CardCategoryRegistry.internalRegister("mobs", class_124.field_1061);
    public static final ICardCategory NATURE = CardCategoryRegistry.internalRegister("nature", class_124.field_1060);
    public static final ICardCategory ITEMS = CardCategoryRegistry.internalRegister("items", class_124.field_1068);

    public static void register(ICardCategory category) {
        if (REGISTRY.put(category.getId(), category) != null) {
            throw new IllegalStateException("Duplicate card category: " + category.getId());
        }
    }

    public static ICardCategory getByKey(class_2960 key) {
        return REGISTRY.get(key);
    }

    public static Collection<ICardCategory> getValues() {
        return REGISTRY.values();
    }

    public static int getCount() {
        return REGISTRY.size();
    }

    public static ICardCategory byIndex(int index) {
        return REGISTRY.values().stream().filter(cat -> cat.getIndex() == index).findFirst().orElse(null);
    }

    private static ICardCategory internalRegister(String id, class_124 formatting) {
        CardCategory category = new CardCategory(new class_2960("collectorsalbum", id), formatting);
        CardCategoryRegistry.register(category);
        return category;
    }
}

