/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common.init;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import team.tnt.collectoralbum.data.packs.CardDropProviderType;
import team.tnt.collectoralbum.data.packs.ICardDropProvider;
import team.tnt.collectoralbum.data.packs.ICardDropSerializer;
import team.tnt.collectoralbum.data.packs.ItemCardProvider;
import team.tnt.collectoralbum.data.packs.MultiDropProvider;
import team.tnt.collectoralbum.data.packs.RepeatedDropProvider;
import team.tnt.collectoralbum.data.packs.TagCardProvider;
import team.tnt.collectoralbum.data.packs.WeightedDropProvider;

public final class CardDropProviderRegistry {
    private static final Map<class_2960, CardDropProviderType<?>> REGISTRY = new HashMap();
    public static final CardDropProviderType<ItemCardProvider> ITEM = CardDropProviderRegistry.register("item", new ItemCardProvider.Serializer());
    public static final CardDropProviderType<TagCardProvider> TAG = CardDropProviderRegistry.register("tag", new TagCardProvider.Serializer());
    public static final CardDropProviderType<MultiDropProvider> MULTI = CardDropProviderRegistry.register("multiple", new MultiDropProvider.Serializer());
    public static final CardDropProviderType<WeightedDropProvider> WEIGHTED = CardDropProviderRegistry.register("weighted", new WeightedDropProvider.Serializer());
    public static final CardDropProviderType<RepeatedDropProvider> REPEATED = CardDropProviderRegistry.register("repeat", new RepeatedDropProvider.Serializer());

    public static <P extends ICardDropProvider> CardDropProviderType<P> registerProviderType(CardDropProviderType<P> providerType) {
        REGISTRY.put(providerType.identifier(), providerType);
        return providerType;
    }

    public static <P extends ICardDropProvider> CardDropProviderType<P> findInRegistry(class_2960 identifier) {
        return REGISTRY.get(identifier);
    }

    private static <P extends ICardDropProvider> CardDropProviderType<P> register(String id, ICardDropSerializer<P> serializer) {
        return CardDropProviderRegistry.registerProviderType(new CardDropProviderType<P>(new class_2960("collectorsalbum", id), serializer));
    }
}

