/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import team.tnt.collectoralbum.data.boosts.ActionType;
import team.tnt.collectoralbum.data.boosts.IAction;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.IDescriptionProvider;
import team.tnt.collectoralbum.data.boosts.OpType;

public final class AlbumCardBoostCollection {
    private final Map<OpType, IAction[]> byOps = new EnumMap<OpType, IAction[]>(OpType.class);

    public AlbumCardBoostCollection(IAction[] cleanUpActions, IAction[] activeActions) {
        this.byOps.put(OpType.CLEANUP, cleanUpActions);
        this.byOps.put(OpType.ACTIVE, activeActions);
    }

    public static AlbumCardBoostCollection empty() {
        return new AlbumCardBoostCollection(new IAction[0], new IAction[0]);
    }

    public void processOp(OpType type, IBoostContext ctx) {
        Optional.ofNullable(this.byOps.get((Object)type)).stream().flatMap(Arrays::stream).forEach(action -> action.apply(ctx));
    }

    public int getActionsCount(OpType type) {
        IAction[] actions = this.byOps.get((Object)type);
        return actions != null ? actions.length : 0;
    }

    public class_2561[] getPagedDescription(int index) {
        IAction[] actions = this.byOps.get((Object)OpType.ACTIVE);
        if (actions == null || actions.length == 0 || index >= actions.length) {
            return new class_2561[0];
        }
        List<IAction> sortedActions = Arrays.asList(actions);
        sortedActions.sort(IDescriptionProvider::compareTo);
        IAction action = sortedActions.get(index);
        return action.getDescription();
    }

    public void encode(class_2540 buffer) {
        IAction[] actions = this.byOps.get((Object)OpType.ACTIVE);
        int length = actions != null ? actions.length : 0;
        buffer.writeInt(length);
        if (length > 0) {
            for (IAction action : actions) {
                ActionType.encode(action, buffer);
            }
        }
    }

    public void decode(class_2540 buffer) {
        int count = buffer.readInt();
        IAction[] actions = new IAction[count];
        for (int i = 0; i < count; ++i) {
            actions[i] = ActionType.decode(buffer);
        }
        this.byOps.put(OpType.ACTIVE, actions);
    }
}

