/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.tnt.collectoralbum.data.boosts.ActionType;
import team.tnt.collectoralbum.data.boosts.AlbumCardBoostCollection;
import team.tnt.collectoralbum.data.boosts.IAction;
import team.tnt.collectoralbum.data.boosts.OpType;
import team.tnt.collectoralbum.util.JsonHelper;

public class AlbumCardBoostManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger(AlbumCardBoostManager.class);
    private static final class_2960 FABRIC_ID = new class_2960("collectorsalbum", "album_card_boost_manager");
    private static final Gson GSON = new Gson();
    private AlbumCardBoostCollection collection = AlbumCardBoostCollection.empty();

    public AlbumCardBoostManager() {
        super(GSON, "card_boosts");
    }

    public Optional<AlbumCardBoostCollection> getBoosts() {
        return Optional.ofNullable(this.collection);
    }

    public class_2960 getFabricId() {
        return FABRIC_ID;
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        LOGGER.info("Loading album boosts");
        EnumMap<OpType, List> loaded = new EnumMap<OpType, List>(OpType.class);
        for (Map.Entry<class_2960, JsonElement> entry : object.entrySet()) {
            class_2960 filePath = entry.getKey();
            JsonElement fileData = entry.getValue();
            try {
                JsonObject data = JsonHelper.asObject(fileData);
                String opTypeId = class_3518.method_15265((JsonObject)data, (String)"op");
                OpType type = OpType.valueOf(opTypeId);
                List values = loaded.computeIfAbsent(type, k -> new ArrayList());
                Object action = ActionType.fromJson(type, class_3518.method_15296((JsonObject)data, (String)"action"));
                values.add(action);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("Error loading {} file: {}", (Object)filePath, (Object)e);
            }
        }
        this.collection = new AlbumCardBoostCollection((IAction[])((List)loaded.get((Object)OpType.CLEANUP)).toArray(IAction[]::new), (IAction[])((List)loaded.get((Object)OpType.ACTIVE)).toArray(IAction[]::new));
        LOGGER.info("Album boosts loaded");
    }
}

