/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import team.tnt.collectoralbum.common.AlbumStats;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.init.CardBoostConditionRegistry;
import team.tnt.collectoralbum.common.init.CardCategoryRegistry;
import team.tnt.collectoralbum.common.item.CardRarity;
import team.tnt.collectoralbum.common.item.ICard;
import team.tnt.collectoralbum.data.boosts.CardBoostConditionType;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.ICardBoostCondition;
import team.tnt.collectoralbum.data.boosts.ICardBoostConditionSerializer;
import team.tnt.collectoralbum.data.boosts.IDescriptionProvider;
import team.tnt.collectoralbum.data.boosts.PointsCondition;
import team.tnt.collectoralbum.util.JsonHelper;
import team.tnt.collectoralbum.util.TextHelper;

public class CardsCondition
implements ICardBoostCondition {
    private final ICardCategory category;
    private final CardRarity rarity;
    private final int count;
    private final class_2561[] description;

    private CardsCondition(ICardCategory category, CardRarity rarity, int count) {
        this.category = category;
        this.rarity = rarity;
        this.count = count;
        this.description = new class_2561[]{this.createFullDescription()};
    }

    @Override
    public CardBoostConditionType<?> getType() {
        return CardBoostConditionRegistry.CARDS;
    }

    @Override
    public boolean isValid(IBoostContext context) {
        AlbumStats stats = context.get("stats", AlbumStats.class);
        Map<ICardCategory, List<ICard>> map = stats.getCardsByCategory();
        List<Object> cardList = this.category == null ? CardCategoryRegistry.getValues().stream().flatMap(cat -> Optional.ofNullable((List)map.get(cat)).stream()).flatMap(Collection::stream).toList() : Optional.ofNullable(map.get(this.category)).orElse(Collections.emptyList());
        if (this.rarity != null) {
            cardList = cardList.stream().filter(card -> card.getCardRarity() == this.rarity).toList();
        }
        return cardList.size() >= this.count;
    }

    @Override
    public class_2561[] getDescription() {
        return this.description;
    }

    private class_2561 createFullDescription() {
        class_5250 wildcard = class_2561.method_43471((String)"text.collectorsalbum.album.boost.condition.cards.wildcard");
        class_5250 count = class_2561.method_43471((String)String.valueOf(this.count)).method_27692(class_124.field_1075);
        class_5250 categoryText = this.category != null ? class_2561.method_43470((String)this.category.getTranslatedName().getString()).method_27692(this.category.getTooltipFormat()) : wildcard;
        class_5250 rarityText = this.rarity != null ? this.rarity.getTranslatedName() : wildcard;
        return class_2561.method_43469((String)"text.collectorsalbum.album.boost.condition.cards", (Object[])new Object[]{count, rarityText, categoryText}).method_27692(class_124.field_1080);
    }

    @Override
    public int compareTo(@NotNull IDescriptionProvider o) {
        if (o instanceof PointsCondition) {
            return 1;
        }
        if (o instanceof CardsCondition) {
            CardsCondition c = (CardsCondition)o;
            CardRarity oRarity = c.rarity;
            int oCount = c.count;
            if (oCount == this.count) {
                if (Objects.equals((Object)this.rarity, (Object)oRarity)) {
                    if (this.category == null && Objects.equals(this.category, c.category)) {
                        return 0;
                    }
                    return this.category.getIndex() - c.category.getIndex();
                }
                return this.rarity == null || oRarity == null ? TextHelper.nullSortFirst(this.rarity, oRarity) : this.rarity.ordinal() - oRarity.ordinal();
            }
            return this.count - oCount;
        }
        return 0;
    }

    public static final class Serializer
    implements ICardBoostConditionSerializer<CardsCondition> {
        @Override
        public CardsCondition fromJson(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asObject(element);
            String categoryId = JsonHelper.resolveNullable(object, "category", JsonElement::getAsString);
            String rarityId = JsonHelper.resolveNullable(object, "rarity", JsonElement::getAsString);
            CardRarity rarity = null;
            if (rarityId != null) {
                try {
                    rarity = CardRarity.valueOf(rarityId);
                }
                catch (IllegalArgumentException e) {
                    throw new JsonSyntaxException("Unknown card rarity: " + rarityId);
                }
            }
            ICardCategory category = null;
            if (categoryId != null && (category = CardCategoryRegistry.getByKey(new class_2960(categoryId))) == null) {
                throw new JsonSyntaxException("Unknown card category: " + categoryId);
            }
            int requiredCount = class_3518.method_15260((JsonObject)object, (String)"count");
            return new CardsCondition(category, rarity, requiredCount);
        }

        @Override
        public void networkEncode(CardsCondition condition, class_2540 buffer) {
            ICardCategory cardCategory = condition.category;
            CardRarity rarity = condition.rarity;
            buffer.writeBoolean(cardCategory != null);
            if (cardCategory != null) {
                buffer.method_10812(cardCategory.getId());
            }
            buffer.writeBoolean(rarity != null);
            if (rarity != null) {
                buffer.method_10817((Enum)rarity);
            }
            buffer.writeInt(condition.count);
        }

        @Override
        public CardsCondition networkDecode(CardBoostConditionType<CardsCondition> type, class_2540 buffer) {
            boolean hasCategory = buffer.readBoolean();
            ICardCategory cardCategory = hasCategory ? CardCategoryRegistry.getByKey(buffer.method_10810()) : null;
            boolean hasRarity = buffer.readBoolean();
            CardRarity rarity = hasRarity ? (CardRarity)buffer.method_10818(CardRarity.class) : null;
            int count = buffer.readInt();
            return new CardsCondition(cardCategory, rarity, count);
        }
    }
}

