/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;
import team.tnt.collectoralbum.common.init.ActionTypeRegistry;
import team.tnt.collectoralbum.data.boosts.ActionType;
import team.tnt.collectoralbum.data.boosts.CardBoostConditionType;
import team.tnt.collectoralbum.data.boosts.IAction;
import team.tnt.collectoralbum.data.boosts.IActionSerializer;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.ICardBoostCondition;
import team.tnt.collectoralbum.data.boosts.IDescriptionProvider;
import team.tnt.collectoralbum.data.boosts.OpType;
import team.tnt.collectoralbum.util.JsonHelper;

public class FirstValidAction
implements IAction {
    private final Entry[] entries;
    private final class_2561[] description;

    private FirstValidAction(Entry[] entries) {
        this.entries = entries;
        this.description = this.generateDescription(entries);
    }

    @Override
    public ActionType<?> getType() {
        return ActionTypeRegistry.FIRST_VALID;
    }

    @Override
    public void apply(IBoostContext context) {
        for (Entry entry : this.entries) {
            if (!entry.accepts(context)) continue;
            entry.apply(context);
            break;
        }
    }

    @Override
    public class_2561[] getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(@NotNull IDescriptionProvider o) {
        if (o instanceof FirstValidAction) {
            FirstValidAction fva = (FirstValidAction)o;
            Entry[] vals = fva.entries;
            if (this.entries.length > 0 && vals.length > 0) {
                return this.compareEntries(this.entries[0], vals[0]);
            }
            return this.entries.length - vals.length;
        }
        return 0;
    }

    private class_2561[] generateDescription(Entry[] entries) {
        return (class_2561[])Arrays.stream(entries).sorted(this::compareEntries).flatMap(e -> Arrays.stream(e.getDescription())).toArray(class_2561[]::new);
    }

    private int compareEntries(Entry o1, Entry o2) {
        ICardBoostCondition[] c1 = o1.conditions;
        ICardBoostCondition[] c2 = o2.conditions;
        if (c1.length > 0 && c2.length > 0) {
            return c1[0].compareTo(c2[0]);
        }
        return o1.action.compareTo(o2.action);
    }

    public static final class Entry
    implements IDescriptionProvider {
        private final ICardBoostCondition[] conditions;
        private final IAction action;

        public Entry(ICardBoostCondition[] conditions, IAction action) {
            this.conditions = conditions;
            this.action = action;
        }

        public boolean accepts(IBoostContext ctx) {
            for (ICardBoostCondition condition : this.conditions) {
                if (condition.isValid(ctx)) continue;
                return false;
            }
            return true;
        }

        public void apply(IBoostContext ctx) {
            this.action.apply(ctx);
        }

        @Override
        public class_2561[] getDescription() {
            class_2561[] conditionsDesc = (class_2561[])Arrays.stream(this.conditions).flatMap(cond -> Arrays.stream(cond.getDescription())).toArray(class_2561[]::new);
            class_2561[] actionDesc = this.action.getDescription();
            class_2561[] res = new class_2561[conditionsDesc.length + actionDesc.length];
            System.arraycopy(conditionsDesc, 0, res, 0, conditionsDesc.length);
            System.arraycopy(actionDesc, 0, res, conditionsDesc.length, actionDesc.length);
            return res;
        }

        static Entry fromJson(JsonElement element, OpType opType) throws JsonParseException {
            JsonObject object = JsonHelper.asObject(element);
            JsonObject applyAction = class_3518.method_15296((JsonObject)object, (String)"apply");
            JsonArray conditionsArray = class_3518.method_15292((JsonObject)object, (String)"conditions", (JsonArray)new JsonArray());
            Object action = ActionType.fromJson(opType, applyAction);
            ICardBoostCondition[] conditions = JsonHelper.resolveArray(conditionsArray, ICardBoostCondition[]::new, CardBoostConditionType::fromJson);
            return new Entry(conditions, (IAction)action);
        }

        void encode(class_2540 buffer) {
            ActionType.encode(this.action, buffer);
            buffer.writeInt(this.conditions.length);
            for (ICardBoostCondition condition : this.conditions) {
                CardBoostConditionType.encode(condition, buffer);
            }
        }

        static Entry decode(class_2540 buffer) {
            Object action = ActionType.decode(buffer);
            int count = buffer.readInt();
            ICardBoostCondition[] cardBoostConditions = new ICardBoostCondition[count];
            for (int i = 0; i < count; ++i) {
                cardBoostConditions[i] = CardBoostConditionType.decode(buffer);
            }
            return new Entry(cardBoostConditions, (IAction)action);
        }
    }

    public static final class Serializer
    implements IActionSerializer<FirstValidAction> {
        @Override
        public FirstValidAction fromJson(JsonObject data, OpType opType) throws JsonParseException {
            JsonArray valuesArr = class_3518.method_15261((JsonObject)data, (String)"values");
            Entry[] entries = JsonHelper.resolveArray(valuesArr, Entry[]::new, element -> Entry.fromJson(element, opType));
            return new FirstValidAction(entries);
        }

        @Override
        public void networkEncode(FirstValidAction action, class_2540 buffer) {
            buffer.writeInt(action.entries.length);
            for (Entry entry : action.entries) {
                entry.encode(buffer);
            }
        }

        @Override
        public FirstValidAction networkDecode(ActionType<FirstValidAction> type, class_2540 buffer) {
            int i = buffer.readInt();
            Entry[] entries = new Entry[i];
            for (int j = 0; j < i; ++j) {
                entries[j] = Entry.decode(buffer);
            }
            return new FirstValidAction(entries);
        }
    }
}

