/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import team.tnt.collectoralbum.common.init.ActionTypeRegistry;
import team.tnt.collectoralbum.data.boosts.ActionType;
import team.tnt.collectoralbum.data.boosts.IAction;
import team.tnt.collectoralbum.data.boosts.IActionSerializer;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.OpType;
import team.tnt.collectoralbum.util.JsonHelper;
import team.tnt.collectoralbum.util.TextHelper;

public class GiveEffectsAction
implements IAction {
    private final IEffectFactory[] effects;
    private final class_2561[] description;

    private GiveEffectsAction(IEffectFactory[] effects) {
        this.effects = effects;
        this.description = GiveEffectsAction.generateDescriptionForEffects(effects);
    }

    @Override
    public ActionType<?> getType() {
        return ActionTypeRegistry.GIVE_EFFECTS;
    }

    public static class_2561[] generateDescriptionForEffects(IEffectFactory[] factories) {
        class_2561[] res = new class_2561[factories.length];
        int index = 0;
        for (IEffectFactory factory : factories) {
            class_1293 instance = factory.makeEffect();
            class_2561 displayText = instance.method_5579().method_5560();
            String amplifier = TextHelper.toRomanNumberString(instance.method_5578() + 1);
            class_5250 effectValue = class_2561.method_43470((String)(displayText.getString() + " " + amplifier)).method_27692(class_124.field_1060);
            res[index++] = class_2561.method_43469((String)"text.collectorsalbum.album.boost.effect_instance", (Object[])new Object[]{effectValue}).method_27692(class_124.field_1054);
        }
        return res;
    }

    @Override
    public void apply(IBoostContext context) {
        class_1657 player = context.get("player", class_1657.class);
        for (IEffectFactory factory : this.effects) {
            class_1293 instance = factory.makeEffect();
            player.method_6092(instance);
        }
    }

    @Override
    public class_2561[] getDescription() {
        return this.description;
    }

    public static void encodeEffectFactory(IEffectFactory factory, class_2540 buffer) {
        class_1293 instance = factory.makeEffect();
        class_1291 type = instance.method_5579();
        class_2960 effectId = class_2378.field_11159.method_10221((Object)type);
        buffer.method_10812(effectId);
        buffer.writeInt(instance.method_5584());
        buffer.writeInt(instance.method_5578());
        buffer.writeBoolean(instance.method_5591());
        buffer.writeBoolean(instance.method_5581());
        buffer.writeBoolean(instance.method_5592());
    }

    public static IEffectFactory decodeEffectFactory(class_2540 buffer) {
        class_2960 effectId = buffer.method_10810();
        class_1291 type = (class_1291)class_2378.field_11159.method_10223(effectId);
        int duration = buffer.readInt();
        int amplifier = buffer.readInt();
        boolean ambient = buffer.readBoolean();
        boolean visible = buffer.readBoolean();
        boolean icon = buffer.readBoolean();
        return () -> new class_1293(type, duration, amplifier, ambient, visible, icon);
    }

    @FunctionalInterface
    static interface IEffectFactory {
        public class_1293 makeEffect();
    }

    public static final class Serializer
    implements IActionSerializer<GiveEffectsAction> {
        @Override
        public GiveEffectsAction fromJson(JsonObject data, OpType opType) throws JsonParseException {
            JsonArray array = class_3518.method_15261((JsonObject)data, (String)"effects");
            IEffectFactory[] factories = new IEffectFactory[array.size()];
            int i = 0;
            for (JsonElement element : array) {
                JsonObject effectJson = JsonHelper.asObject(element);
                class_2960 effectId = new class_2960(class_3518.method_15265((JsonObject)effectJson, (String)"effect"));
                class_1291 effect = (class_1291)class_2378.field_11159.method_10223(effectId);
                if (effect == null) {
                    throw new JsonSyntaxException("Unknown effect: " + effectId);
                }
                int duration = Math.max(class_3518.method_15282((JsonObject)effectJson, (String)"duration", (int)20), 0);
                int amplifier = class_3532.method_15340((int)class_3518.method_15282((JsonObject)effectJson, (String)"amplifier", (int)0), (int)0, (int)255);
                boolean ambient = class_3518.method_15258((JsonObject)effectJson, (String)"ambient", (boolean)false);
                boolean visible = class_3518.method_15258((JsonObject)effectJson, (String)"visible", (boolean)true);
                boolean showIcon = class_3518.method_15258((JsonObject)effectJson, (String)"showIcon", (boolean)true);
                factories[i++] = () -> new class_1293(effect, duration, amplifier, ambient, visible, showIcon);
            }
            return new GiveEffectsAction(factories);
        }

        @Override
        public void networkEncode(GiveEffectsAction action, class_2540 buffer) {
            buffer.writeInt(action.effects.length);
            for (IEffectFactory factory : action.effects) {
                GiveEffectsAction.encodeEffectFactory(factory, buffer);
            }
        }

        @Override
        public GiveEffectsAction networkDecode(ActionType<GiveEffectsAction> type, class_2540 buffer) {
            IEffectFactory[] factories = new IEffectFactory[buffer.readInt()];
            for (int i = 0; i < factories.length; ++i) {
                factories[i] = GiveEffectsAction.decodeEffectFactory(buffer);
            }
            return new GiveEffectsAction(factories);
        }
    }
}

