/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import team.tnt.collectoralbum.common.init.ActionTypeRegistry;
import team.tnt.collectoralbum.data.boosts.ActionType;
import team.tnt.collectoralbum.data.boosts.GiveEffectsAction;
import team.tnt.collectoralbum.data.boosts.IAction;
import team.tnt.collectoralbum.data.boosts.IActionSerializer;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.OpType;
import team.tnt.collectoralbum.util.JsonHelper;

public class GiveMissingEffectAction
implements IAction {
    private final GiveEffectsAction.IEffectFactory[] factories;
    private final class_2561[] description;

    public GiveMissingEffectAction(GiveEffectsAction.IEffectFactory[] factories) {
        this.factories = factories;
        this.description = GiveEffectsAction.generateDescriptionForEffects(factories);
    }

    @Override
    public ActionType<?> getType() {
        return ActionTypeRegistry.GIVE_MISSING_EFFECTS;
    }

    @Override
    public void apply(IBoostContext context) {
        class_1657 player = context.get("player", class_1657.class);
        for (GiveEffectsAction.IEffectFactory factory : this.factories) {
            class_1293 instance = factory.makeEffect();
            class_1293 old = player.method_6112(instance.method_5579());
            if (old != null && old.method_5578() == instance.method_5578()) continue;
            player.method_6016(instance.method_5579());
            player.method_6092(instance);
        }
    }

    @Override
    public class_2561[] getDescription() {
        return this.description;
    }

    public static final class Serializer
    implements IActionSerializer<GiveMissingEffectAction> {
        @Override
        public GiveMissingEffectAction fromJson(JsonObject data, OpType opType) throws JsonParseException {
            JsonArray array = class_3518.method_15261((JsonObject)data, (String)"effects");
            GiveEffectsAction.IEffectFactory[] factories = new GiveEffectsAction.IEffectFactory[array.size()];
            int i = 0;
            for (JsonElement element : array) {
                JsonObject effectJson = JsonHelper.asObject(element);
                class_2960 effectId = new class_2960(class_3518.method_15265((JsonObject)effectJson, (String)"effect"));
                class_1291 effect = (class_1291)class_2378.field_11159.method_10223(effectId);
                if (effect == null) {
                    throw new JsonSyntaxException("Unknown effect: " + effectId);
                }
                int duration = Math.max(class_3518.method_15282((JsonObject)effectJson, (String)"duration", (int)20), 0);
                int amplifier = class_3532.method_15340((int)class_3518.method_15282((JsonObject)effectJson, (String)"amplifier", (int)0), (int)0, (int)255);
                boolean ambient = class_3518.method_15258((JsonObject)effectJson, (String)"ambient", (boolean)false);
                boolean visible = class_3518.method_15258((JsonObject)effectJson, (String)"visible", (boolean)true);
                boolean showIcon = class_3518.method_15258((JsonObject)effectJson, (String)"showIcon", (boolean)true);
                factories[i++] = () -> new class_1293(effect, duration, amplifier, ambient, visible, showIcon);
            }
            return new GiveMissingEffectAction(factories);
        }

        @Override
        public void networkEncode(GiveMissingEffectAction action, class_2540 buffer) {
            buffer.writeInt(action.factories.length);
            for (GiveEffectsAction.IEffectFactory factory : action.factories) {
                GiveEffectsAction.encodeEffectFactory(factory, buffer);
            }
        }

        @Override
        public GiveMissingEffectAction networkDecode(ActionType<GiveMissingEffectAction> type, class_2540 buffer) {
            GiveEffectsAction.IEffectFactory[] factories = new GiveEffectsAction.IEffectFactory[buffer.readInt()];
            for (int i = 0; i < factories.length; ++i) {
                factories[i] = GiveEffectsAction.decodeEffectFactory(buffer);
            }
            return new GiveMissingEffectAction(factories);
        }
    }
}

