/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import team.tnt.collectoralbum.common.AlbumStats;
import team.tnt.collectoralbum.common.init.CardBoostConditionRegistry;
import team.tnt.collectoralbum.data.boosts.CardBoostConditionType;
import team.tnt.collectoralbum.data.boosts.CardsCondition;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.ICardBoostCondition;
import team.tnt.collectoralbum.data.boosts.ICardBoostConditionSerializer;
import team.tnt.collectoralbum.data.boosts.IDescriptionProvider;
import team.tnt.collectoralbum.util.JsonHelper;

public class PointsCondition
implements ICardBoostCondition {
    private final int minPoints;
    private final class_2561[] description;

    private PointsCondition(int minPoints) {
        this.minPoints = minPoints;
        this.description = new class_2561[]{this.getDescriptionText()};
    }

    @Override
    public CardBoostConditionType<?> getType() {
        return CardBoostConditionRegistry.POINTS;
    }

    @Override
    public boolean isValid(IBoostContext context) {
        AlbumStats stats = context.get("stats", AlbumStats.class);
        int points = stats.getPoints();
        return points >= this.minPoints;
    }

    @Override
    public class_2561[] getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(@NotNull IDescriptionProvider o) {
        if (o instanceof CardsCondition) {
            return -1;
        }
        if (o instanceof PointsCondition) {
            PointsCondition c = (PointsCondition)o;
            return this.minPoints - c.minPoints;
        }
        return 0;
    }

    private class_2561 getDescriptionText() {
        class_5250 points = class_2561.method_43470((String)String.valueOf(this.minPoints)).method_27692(class_124.field_1075);
        return class_2561.method_43469((String)"text.collectorsalbum.album.boost.condition.points", (Object[])new Object[]{points}).method_27692(class_124.field_1080);
    }

    public static final class Serializer
    implements ICardBoostConditionSerializer<PointsCondition> {
        @Override
        public PointsCondition fromJson(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asObject(element);
            int minPoints = class_3518.method_15260((JsonObject)object, (String)"points");
            return new PointsCondition(minPoints);
        }

        @Override
        public void networkEncode(PointsCondition condition, class_2540 buffer) {
            buffer.writeInt(condition.minPoints);
        }

        @Override
        public PointsCondition networkDecode(CardBoostConditionType<PointsCondition> type, class_2540 buffer) {
            return new PointsCondition(buffer.readInt());
        }
    }
}

