/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.packs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.tnt.collectoralbum.data.packs.CardDropProviderType;
import team.tnt.collectoralbum.data.packs.ICardDropProvider;

public class CardPackLootManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final class_2960 FABRIC_ID = new class_2960("collectorsalbum", "card_pack_loot_manager");
    private static final Logger LOGGER = LogManager.getLogger(CardPackLootManager.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final Map<class_2960, ICardDropProvider> providerMap = new HashMap<class_2960, ICardDropProvider>();

    public CardPackLootManager() {
        super(GSON, "card_packs");
    }

    public Optional<ICardDropProvider> getProvider(class_2960 identifier) {
        return Optional.ofNullable(this.providerMap.get(identifier));
    }

    public class_2960 getFabricId() {
        return FABRIC_ID;
    }

    protected void apply(Map<class_2960, JsonElement> resources, class_3300 resourceManager, class_3695 profiler) {
        LOGGER.info("Loading card pack drops");
        this.providerMap.clear();
        for (Map.Entry<class_2960, JsonElement> entry : resources.entrySet()) {
            try {
                class_2960 path = entry.getKey();
                JsonElement data = entry.getValue();
                Object provider = CardDropProviderType.fromJson(data);
                this.providerMap.put(path, (ICardDropProvider)provider);
            }
            catch (JsonParseException e) {
                LOGGER.error("Error loading card pack provider with id {}, error {}", (Object)entry.getKey(), (Object)e);
            }
        }
        LOGGER.info("Loaded {} card pack drops", (Object)this.providerMap.size());
    }
}

